/*
 * Decompiled with CFR 0.152.
 */
package fecimpl;

import java.util.logging.Logger;

class SegmentationParams {
    private static Logger logger = Logger.getLogger(SegmentationParams.class.getName());
    public final int baseN;
    public final int baseK;
    public final int endN;
    public final int endK;
    public final int baseBlockSize;
    public final int endBlockSize;
    public final int baseStripeWidth;
    public final int endStripeWidth;
    public final int baseSegmentSize;
    public final int endSegmentSize;
    public final int segments;
    private static final int C_128K = 131072;
    private static final int C_256K = 262144;
    private static final int C_512K = 524288;
    private static final int C_1M = 0x100000;
    private static final int C_16M = 0x1000000;
    private static final int C_32M = 0x2000000;
    private static final int C_64M = 0x4000000;
    private static final int C_128M = 0x8000000;
    private static final long C_SEGLEN = 0x8000000L;
    private static final int C_MIN_SEGLEN = 786432;

    SegmentationParams(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        this.baseN = n;
        this.baseK = n2;
        this.endN = n3;
        this.endK = n4;
        this.baseBlockSize = n5;
        this.endBlockSize = n6;
        this.baseStripeWidth = n7;
        this.endStripeWidth = n8;
        this.baseSegmentSize = n9;
        this.endSegmentSize = n10;
        this.segments = n11;
    }

    SegmentationParams(long l, int n, int n2) {
        if (l < 1L || n < 1 || n2 < 1) {
            throw new IllegalArgumentException("len=" + l + " redundancyNum=" + n + " redundancyDenom=" + n2);
        }
        int n3 = (int)(l / 0x8000000L);
        if (l % 0x8000000L != 0L) {
            ++n3;
        }
        this.segments = n3;
        long l2 = l;
        if (l > 0x8000000L) {
            l2 = 0x8000000L;
        }
        if (l2 < 786432L) {
            l2 = 786432L;
        }
        this.baseSegmentSize = (int)l2;
        this.baseBlockSize = SegmentationParams.selectBlockSize(this.baseSegmentSize);
        this.baseK = SegmentationParams.calculateK(this.baseSegmentSize, this.baseBlockSize);
        this.baseN = SegmentationParams.calculateN(this.baseK, n, n2);
        this.baseStripeWidth = SegmentationParams.selectStripeWidth(this.baseSegmentSize, this.baseBlockSize);
        if (this.segments > 1) {
            l2 = l % (long)this.baseSegmentSize;
            if (l2 == 0L) {
                this.endSegmentSize = this.baseSegmentSize;
                this.endBlockSize = this.baseBlockSize;
                this.endK = this.baseK;
                this.endN = this.baseN;
                this.endStripeWidth = this.baseStripeWidth;
            } else {
                if (l2 > 0x8000000L) {
                    throw new RuntimeException("assertion failure: segLen <= 134217728");
                }
                if (l2 < 786432L) {
                    l2 = 786432L;
                }
                this.endSegmentSize = (int)l2;
                this.endBlockSize = SegmentationParams.selectBlockSize(this.endSegmentSize);
                this.endK = SegmentationParams.calculateK(this.endSegmentSize, this.endBlockSize);
                this.endN = SegmentationParams.calculateN(this.endK, n, n2);
                this.endStripeWidth = SegmentationParams.selectStripeWidth(this.endSegmentSize, this.endBlockSize);
            }
        } else {
            this.endSegmentSize = this.baseSegmentSize;
            this.endBlockSize = this.baseBlockSize;
            this.endK = this.baseK;
            this.endN = this.baseN;
            this.endStripeWidth = this.baseStripeWidth;
        }
    }

    public final void dump() {
        logger.fine("----------------------------------------\nbaseN: " + this.baseN + "\n" + "baseK: " + this.baseK + "\n" + "endN: " + this.endN + "\n" + "endK: " + this.endK + "\n" + "baseBlockSize: " + this.baseBlockSize + "\n" + "endBlockSize: " + this.endBlockSize + "\n" + "baseStripeWidth: " + this.baseStripeWidth + "\n" + "endStripeWidth: " + this.endStripeWidth + "\n" + "baseSegmentSize: " + this.baseSegmentSize + "\n" + "endSegmentSize: " + this.endSegmentSize + "\n" + "segments: " + this.segments + "\n" + "----------------------------------------");
    }

    private static final int selectBlockSize(long l) {
        int n = l < 0x100000L ? 131072 : (l < 0x2000000L ? 262144 : (l < 0x4000000L ? 524288 : 0x100000));
        return n;
    }

    private static final int calculateK(long l, int n) {
        int n2 = 0;
        if (l < 0x8000000L) {
            n2 = (int)(l / (long)n);
            if (l % (long)n != 0L) {
                ++n2;
            }
        } else {
            n2 = (int)(0x8000000L / (long)n);
        }
        return n2;
    }

    private static final int calculateN(int n, int n2, int n3) {
        if (n > 128) {
            throw new IllegalArgumentException("k > 128!");
        }
        if ((double)n2 / (double)n3 > 0.5) {
            throw new IllegalArgumentException("Maximum allowed redundancy is 50%.");
        }
        int n4 = n + n * n2 / n3;
        if (n4 == n) {
            ++n4;
        }
        return n4;
    }

    private static final int selectStripeWidth(int n, int n2) {
        int n3 = -1;
        if (n > 0x1000000) {
            int n4 = 1;
            while (n / n4 > 0x1000000) {
                n4 <<= 1;
            }
            n3 = n2 / n4;
            if (n2 % n4 != 0) {
                throw new RuntimeException("assertion failure: blockSize % stripeCount == 0");
            }
        }
        return n3;
    }
}

