/*
 * Decompiled with CFR 0.152.
 */
package fecimpl;

import fecimpl.FECUtils;
import fecimpl.OnionFECBase;
import freenet.client.FECDecoder;
import freenet.support.Bucket;
import freenet.support.StripedBucketArray;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;

public class OnionFECDecoder
extends OnionFECBase
implements FECDecoder {
    private static Logger logger = Logger.getLogger(OnionFECDecoder.class.getName());
    private Hashtable buckets = new Hashtable();

    public OnionFECDecoder() {
        this("OnionFEC_a_1_2", 1, 2);
    }

    protected OnionFECDecoder(String string, int n, int n2) {
        super(string, n, n2);
    }

    public void release() {
        this.releaseBuckets();
        super.release();
    }

    public void putBucket(Bucket bucket, int n) throws IOException {
        Integer n2 = new Integer(n);
        if (this.buckets.get(n2) != null) {
            throw new IOException("You already put bucket: " + n);
        }
        this.buckets.put(n2, bucket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decode(int[] nArray, Bucket[] bucketArray) throws IOException {
        Object object;
        Bucket[] bucketArray2;
        if (nArray.length != bucketArray.length) {
            return false;
        }
        if (nArray.length == 0) {
            logger.warning("OnionFECDecoder.decode -- Refusing to decode 0 segments.");
            return false;
        }
        if (!this.isDecodable()) {
            return false;
        }
        Bucket[] bucketArray3 = new Bucket[this.n];
        Object object2 = this.buckets.keys();
        while (object2.hasMoreElements()) {
            bucketArray2 = (Bucket[])object2.nextElement();
            object = (Bucket)this.buckets.get(bucketArray2);
            bucketArray3[bucketArray2.intValue()] = object;
        }
        object2 = FECUtils.findNonNullBuckets(bucketArray3, this.k);
        if (((FECUtils.NonNulls)object2).missingIndices.length != nArray.length) {
            return false;
        }
        if (((FECUtils.NonNulls)object2).missingIndices.length > 0) {
            bucketArray2 = null;
            try {
                bucketArray2 = FECUtils.makeBuckets(this.bucketFactory, ((FECUtils.NonNulls)object2).missingIndices.length, this.blockSize, true);
                if (this.stripeWidth == -1) {
                    FECUtils.decode(this.code, ((FECUtils.NonNulls)object2).buckets, ((FECUtils.NonNulls)object2).indices, this.k, ((FECUtils.NonNulls)object2).missingIndices, bucketArray2);
                } else {
                    object = new StripedBucketArray();
                    StripedBucketArray stripedBucketArray = new StripedBucketArray();
                    try {
                        int n = this.blockSize / this.stripeWidth;
                        Bucket[] bucketArray4 = ((StripedBucketArray)object).allocate(((FECUtils.NonNulls)object2).buckets);
                        Bucket[] bucketArray5 = stripedBucketArray.allocate(bucketArray2);
                        for (int i = 0; i < n; ++i) {
                            logger.fine("Decoding stripe " + i);
                            ((StripedBucketArray)object).setRange(i * this.stripeWidth, this.stripeWidth);
                            stripedBucketArray.setRange(i * this.stripeWidth, this.stripeWidth);
                            FECUtils.decode(this.code, bucketArray4, ((FECUtils.NonNulls)object2).indices, this.k, ((FECUtils.NonNulls)object2).missingIndices, bucketArray5);
                        }
                    }
                    finally {
                        ((StripedBucketArray)object).release();
                        stripedBucketArray.release();
                    }
                }
                int n = 0;
                for (int i = 0; i < this.k; ++i) {
                    if (bucketArray3[i] == null) {
                        nArray[n] = i;
                        bucketArray[n] = bucketArray2[n];
                        bucketArray2[n] = null;
                        ++n;
                    }
                    this.buckets.remove(new Integer(i));
                }
                bucketArray2 = null;
            }
            finally {
                FECUtils.freeBuckets(this.bucketFactory, bucketArray2);
                this.releaseBuckets();
            }
        }
        return true;
    }

    public boolean setSegment(int n) {
        if (this.currentSegment != n) {
            this.releaseBuckets();
            return super.setSegment(n);
        }
        return true;
    }

    public boolean isDecodable() {
        return this.buckets.size() >= this.k;
    }

    public int missingBlocks() {
        int n = 0;
        for (int i = 0; i < this.n; ++i) {
            if (this.buckets.get(new Integer(i)) == null) continue;
            ++n;
        }
        return this.n - n;
    }

    private void releaseBuckets() {
        Enumeration enumeration = this.buckets.elements();
        while (enumeration.hasMoreElements()) {
            Bucket bucket = (Bucket)enumeration.nextElement();
            try {
                this.bucketFactory.freeBucket(bucket);
            }
            catch (IOException iOException) {}
        }
        this.buckets.clear();
    }
}

