/*
 * Decompiled with CFR 0.152.
 */
package fecimpl;

import com.onionnetworks.fec.DefaultFECCodeFactory;
import com.onionnetworks.fec.FECCode;
import fecimpl.SegmentationParams;
import freenet.support.BucketFactory;

public class OnionFECBase {
    protected String name = null;
    protected int redundancyNumerator = -1;
    protected int redundancyDenominator = -1;
    protected SegmentationParams segParams = null;
    protected int n = -1;
    protected int k = -1;
    protected int blockSize = -1;
    protected int stripeWidth = -1;
    protected int currentSegment = -1;
    protected FECCode code = null;
    protected BucketFactory bucketFactory = null;

    protected OnionFECBase(String string, int n, int n2) {
        this.name = string;
        this.redundancyNumerator = n;
        this.redundancyDenominator = n2;
    }

    protected SegmentationParams calculateParams(long l) {
        return new SegmentationParams(l, this.redundancyNumerator, this.redundancyDenominator);
    }

    public boolean init(long l, BucketFactory bucketFactory) {
        this.release();
        this.segParams = this.calculateParams(l);
        this.bucketFactory = bucketFactory;
        this.n = this.segParams.baseN;
        this.k = this.segParams.baseK;
        this.blockSize = this.segParams.baseBlockSize;
        this.stripeWidth = this.segParams.baseStripeWidth;
        this.currentSegment = 0;
        DefaultFECCodeFactory defaultFECCodeFactory = new DefaultFECCodeFactory();
        this.code = defaultFECCodeFactory.createFECCode(this.k, this.n);
        return this.code != null;
    }

    public void release() {
        this.code = null;
    }

    public String getName() {
        return this.name;
    }

    public int getBlockSize(int n) {
        if (this.segParams.segments == 1 || n < this.segParams.segments - 1) {
            return this.segParams.baseBlockSize;
        }
        return this.segParams.endBlockSize;
    }

    public int getBlockSize() {
        return this.getBlockSize(this.currentSegment);
    }

    public int getCheckBlockSize(int n) {
        return this.getBlockSize(n);
    }

    public int getCheckBlockSize() {
        return this.getCheckBlockSize(this.currentSegment);
    }

    public int getK() {
        return this.k;
    }

    public int getN() {
        return this.n;
    }

    public int getN(int n) {
        if (this.segParams.segments == 1 || n < this.segParams.segments - 1) {
            return this.segParams.baseN;
        }
        return this.segParams.endN;
    }

    public int getK(int n) {
        if (this.segParams.segments == 1 || n < this.segParams.segments - 1) {
            return this.segParams.baseK;
        }
        return this.segParams.endK;
    }

    public int getTotalN() {
        if (this.segParams.segments == 1) {
            return this.segParams.baseN;
        }
        return (this.segParams.segments - 1) * this.segParams.baseN + this.segParams.endN;
    }

    public int getTotalK() {
        if (this.segParams.segments == 1) {
            return this.segParams.baseK;
        }
        return (this.segParams.segments - 1) * this.segParams.baseK + this.segParams.endK;
    }

    public int getSegmentCount() {
        return this.segParams.segments;
    }

    public int getCurrentSegment() {
        return this.currentSegment;
    }

    public int getSegmentSize() {
        return this.segParams.baseSegmentSize;
    }

    public int getSegmentSize(int n) {
        if (this.segParams.segments == 1 || n < this.segParams.segments - 1) {
            return this.segParams.baseSegmentSize;
        }
        return this.segParams.endSegmentSize;
    }

    public boolean setSegment(int n) {
        DefaultFECCodeFactory defaultFECCodeFactory;
        FECCode fECCode;
        if (n < 0 || n >= this.segParams.segments) {
            return false;
        }
        if (this.segParams.segments < 2 || n == this.currentSegment) {
            return true;
        }
        if (this.currentSegment < this.segParams.segments - 1 && n < this.segParams.segments - 1) {
            return true;
        }
        int n2 = this.segParams.baseN;
        int n3 = this.segParams.baseK;
        int n4 = this.segParams.baseBlockSize;
        int n5 = this.segParams.baseStripeWidth;
        if (n == this.segParams.segments - 1) {
            n3 = this.segParams.endK;
            n2 = this.segParams.endN;
            n4 = this.segParams.endBlockSize;
            n5 = this.segParams.endStripeWidth;
        }
        if ((fECCode = (defaultFECCodeFactory = new DefaultFECCodeFactory()).createFECCode(n3, n2)) != null) {
            this.code = fECCode;
            this.n = n2;
            this.k = n3;
            this.blockSize = n4;
            this.stripeWidth = n5;
            this.currentSegment = n;
            return true;
        }
        return false;
    }
}

