/*
 * Decompiled with CFR 0.152.
 */
package fecimpl;

import com.onionnetworks.fec.DefaultFECCodeFactory;
import com.onionnetworks.fec.FECCode;
import com.onionnetworks.util.Buffer;
import freenet.support.Bucket;
import freenet.support.BucketFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Logger;

public class FECUtils {
    private static Logger logger = Logger.getLogger(FECUtils.class.getName());

    public static final void disableNativeCode() {
        Properties properties = System.getProperties();
        properties.setProperty("com.onionnetworks.fec.keys", "pure8,pure16");
        System.setProperties(properties);
        logger.info("Native code off. Using Java FEC implementaion.");
    }

    static final void encode(FECCode fECCode, int n, int n2, Bucket[] bucketArray, Bucket[] bucketArray2, int[] nArray) throws IOException {
        int n3 = (int)bucketArray[0].size();
        int n4 = n - n2;
        int[] nArray2 = null;
        if (nArray != null) {
            nArray2 = nArray;
        } else {
            nArray2 = new int[n4];
            int n5 = 0;
            for (n5 = 0; n5 < n4; ++n5) {
                nArray2[n5] = n2 + n5;
            }
        }
        if (nArray.length != nArray2.length) {
            throw new IOException("Illegal arguments: requested.length != checkBlocks.length");
        }
        long l = System.currentTimeMillis();
        Buffer[] bufferArray = FECUtils.readBuffers(bucketArray, n3);
        Buffer[] bufferArray2 = FECUtils.allocateBuffers(nArray2.length, n3);
        long l2 = System.currentTimeMillis();
        fECCode.encode(bufferArray, bufferArray2, nArray2);
        long l3 = System.currentTimeMillis();
        int n6 = 0;
        for (n6 = 0; n6 < bufferArray2.length; ++n6) {
            FECUtils.dumpBlock(bufferArray2[n6], bucketArray2[n6]);
        }
        logger.fine("Made " + nArray2.length + " " + n3 + " byte check blocks in " + (System.currentTimeMillis() - l) + "ms (" + (l3 - l2) + "ms for computing).");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Bucket[] decode(Bucket[] bucketArray, int n, BucketFactory bucketFactory) throws IOException {
        DefaultFECCodeFactory defaultFECCodeFactory = new DefaultFECCodeFactory();
        int n2 = bucketArray.length;
        FECCode fECCode = defaultFECCodeFactory.createFECCode(n, n2);
        NonNulls nonNulls = FECUtils.findNonNullBuckets(bucketArray, n);
        int n3 = (int)nonNulls.buckets[0].size();
        Bucket[] bucketArray2 = null;
        Bucket[] bucketArray3 = null;
        try {
            bucketArray3 = FECUtils.makeBuckets(bucketFactory, nonNulls.missingIndices.length, n3, false);
            FECUtils.decode(fECCode, nonNulls.buckets, nonNulls.indices, n, nonNulls.missingIndices, bucketArray3);
            int n4 = 0;
            bucketArray2 = new Bucket[n];
            for (int i = 0; i < n; ++i) {
                if (bucketArray[i] != null) {
                    bucketArray2[i] = bucketArray[i];
                    continue;
                }
                bucketArray2[i] = bucketArray3[n4];
                ++n4;
            }
            bucketArray3 = null;
        }
        catch (Throwable throwable) {
            FECUtils.freeBuckets(bucketFactory, bucketArray3);
            throw throwable;
        }
        FECUtils.freeBuckets(bucketFactory, bucketArray3);
        return bucketArray2;
    }

    static final NonNulls findNonNullBuckets(Bucket[] bucketArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n4 = 0; n4 < bucketArray.length; ++n4) {
            if (bucketArray[n4] != null) {
                ++n3;
                continue;
            }
            if (n4 >= n) continue;
            ++n2;
        }
        NonNulls nonNulls = new NonNulls();
        nonNulls.buckets = new Bucket[n3];
        nonNulls.indices = new int[n3];
        nonNulls.missingIndices = new int[n2];
        int n5 = 0;
        int n6 = 0;
        for (n4 = 0; n4 < bucketArray.length; ++n4) {
            if (bucketArray[n4] != null) {
                nonNulls.buckets[n5] = bucketArray[n4];
                nonNulls.indices[n5] = n4;
                ++n5;
                continue;
            }
            if (n4 >= n) continue;
            nonNulls.missingIndices[n6] = n4;
            ++n6;
        }
        return nonNulls;
    }

    static final void decode(FECCode fECCode, Bucket[] bucketArray, int[] nArray, int n, int[] nArray2, Bucket[] bucketArray2) throws IOException {
        if (bucketArray.length < n) {
            throw new IllegalArgumentException("Not enough packets to decode.");
        }
        long l = bucketArray[0].size();
        Buffer[] bufferArray = FECUtils.readBuffers(bucketArray, (int)l);
        long l2 = System.currentTimeMillis();
        int[] nArray3 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        fECCode.decode(bufferArray, nArray3);
        logger.fine("FEC decode took " + (System.currentTimeMillis() - l2) + "ms.");
        for (int i = 0; i < nArray2.length; ++i) {
            FECUtils.dumpBlock(bufferArray[nArray2[i]], bucketArray2[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Bucket[] makeBuckets(BucketFactory bucketFactory, int n, int n2, boolean bl) throws IOException {
        Bucket[] bucketArray = null;
        Bucket[] bucketArray2 = new Bucket[n];
        byte[] byArray = null;
        int n3 = 0;
        if (bl) {
            byArray = new byte[4096];
            for (n3 = 0; n3 < byArray.length; ++n3) {
                byArray[n3] = 0;
            }
        }
        try {
            for (n3 = 0; n3 < n; ++n3) {
                bucketArray2[n3] = bucketFactory.makeBucket(n2);
                if (!bl) continue;
                OutputStream outputStream = null;
                try {
                    int n4;
                    outputStream = bucketArray2[n3].getOutputStream();
                    for (int i = n2; i > 0; i -= n4) {
                        n4 = byArray.length;
                        if (n4 > i) {
                            n4 = i;
                        }
                        outputStream.write(byArray, 0, n4);
                    }
                    continue;
                }
                finally {
                    if (outputStream != null) {
                        try {
                            outputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            bucketArray = bucketArray2;
            bucketArray2 = null;
        }
        finally {
            FECUtils.freeBuckets(bucketFactory, bucketArray2);
        }
        return bucketArray;
    }

    public static void freeBuckets(BucketFactory bucketFactory, Bucket[] bucketArray) {
        if (bucketArray == null || bucketFactory == null) {
            return;
        }
        for (int i = 0; i < bucketArray.length; ++i) {
            if (bucketArray[i] == null) continue;
            try {
                bucketFactory.freeBucket(bucketArray[i]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            bucketArray[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void read(Bucket bucket, byte[] byArray, int n) throws IOException {
        int n2 = (int)bucket.size();
        int n3 = 0;
        InputStream inputStream = null;
        try {
            inputStream = bucket.getInputStream();
            while (n2 > 0) {
                int n4 = inputStream.read(byArray, n3 + n, n2);
                if (n4 < 0) {
                    throw new IOException("unexpected !");
                }
                n2 -= n4;
                n3 += n4;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final Buffer[] readBuffers(Bucket[] bucketArray, int n) throws IOException {
        Buffer[] bufferArray = new Buffer[bucketArray.length];
        for (int i = 0; i < bucketArray.length; ++i) {
            byte[] byArray = new byte[n];
            int n2 = (int)bucketArray[i].size();
            if (n2 > 0) {
                FECUtils.read(bucketArray[i], byArray, 0);
            } else {
                n2 = 0;
            }
            if (n2 < n) {
                for (int j = n2; j < n; ++j) {
                    byArray[j] = 0;
                }
            }
            bufferArray[i] = new Buffer(byArray);
        }
        return bufferArray;
    }

    private static final Buffer[] allocateBuffers(int n, int n2) {
        Buffer[] bufferArray = new Buffer[n];
        for (int i = 0; i < n; ++i) {
            bufferArray[i] = new Buffer(new byte[n2]);
        }
        return bufferArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void dumpBlock(Buffer buffer, Bucket bucket) throws IOException {
        OutputStream outputStream = null;
        try {
            bucket.resetWrite();
            outputStream = bucket.getOutputStream();
            byte[] byArray = buffer.getBytes();
            int n = byArray.length;
            int n2 = 0;
            outputStream.write(byArray, n2, n);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final Bucket[] dumpBlocks(Buffer[] bufferArray, BucketFactory bucketFactory, int n, int n2) throws IOException {
        int n3 = bufferArray.length;
        if (n3 > n2) {
            n3 = n2;
        }
        Bucket[] bucketArray = new Bucket[n3];
        try {
            for (int i = 0; i < bucketArray.length; ++i) {
                bucketArray[i] = bucketFactory.makeBucket(n);
                FECUtils.dumpBlock(bufferArray[i], bucketArray[i]);
            }
        }
        catch (IOException iOException) {
            for (int i = 0; i < bucketArray.length; ++i) {
                if (bucketArray[i] == null) continue;
                try {
                    bucketFactory.freeBucket(bucketArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw iOException;
        }
        return bucketArray;
    }

    private static final void read(Bucket[] bucketArray, byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        for (n = 0; n < bucketArray.length; ++n) {
            n2 = (int)((long)n2 + bucketArray[n].size());
        }
        if (n2 > byArray.length) {
            throw new IllegalArgumentException("The buffer is too small.");
        }
        n2 = 0;
        for (n = 0; n < bucketArray.length; ++n) {
            FECUtils.read(bucketArray[n], byArray, n2);
            n2 = (int)((long)n2 + bucketArray[n].size());
        }
    }

    static class NonNulls {
        Bucket[] buckets = null;
        int[] indices = null;
        int[] missingIndices = null;

        NonNulls() {
        }
    }
}

