/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

public class Buffer {
    public byte[] b;
    public int off;
    public int len;

    public byte[] getBytes() {
        byte[] byArray = new byte[this.len];
        System.arraycopy(this.b, this.off, byArray, 0, this.len);
        return byArray;
    }

    public boolean equals(Object object) {
        if (object instanceof Buffer) {
            Buffer buffer = (Buffer)object;
            if (buffer.len != this.len) {
                return false;
            }
            int n = 0;
            while (n < this.len) {
                if (buffer.b[buffer.off + n] != this.b[this.off + n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Buffer{length: " + this.len + "; offset: " + this.off + "; ");
        int n = this.off;
        while (n < this.len) {
            stringBuffer.append("" + n + ": " + this.b[n]);
            if (n != this.len - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public Buffer(int n) {
        this(new byte[n]);
    }

    public Buffer(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public Buffer(byte[] byArray, int n, int n2) {
        if (n2 < 0 || n < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("b.length=" + byArray.length + ",off=" + n + ",len=" + n2);
        }
        this.b = byArray;
        this.off = n;
        this.len = n2;
    }
}

