/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.encoders;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.encoders.Encoder;

public class Base64Encoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    protected byte padding = (byte)61;
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        for (int i = 0; i < this.encodingTable.length; ++i) {
            this.decodingTable[this.encodingTable[i]] = (byte)i;
        }
    }

    public Base64Encoder() {
        this.initialiseDecodingTable();
    }

    public int encode(byte[] byArray, int n, int n2, OutputStream outputStream) throws IOException {
        int n3;
        int n4 = n2 % 3;
        int n5 = n2 - n4;
        for (n3 = n; n3 < n + n5; n3 += 3) {
            int n6 = byArray[n3] & 0xFF;
            int n7 = byArray[n3 + 1] & 0xFF;
            int n8 = byArray[n3 + 2] & 0xFF;
            outputStream.write(this.encodingTable[n6 >>> 2 & 0x3F]);
            outputStream.write(this.encodingTable[(n6 << 4 | n7 >>> 4) & 0x3F]);
            outputStream.write(this.encodingTable[(n7 << 2 | n8 >>> 6) & 0x3F]);
            outputStream.write(this.encodingTable[n8 & 0x3F]);
        }
        switch (n4) {
            case 0: {
                break;
            }
            case 1: {
                int n9 = byArray[n + n5] & 0xFF;
                n3 = n9 >>> 2 & 0x3F;
                int n10 = n9 << 4 & 0x3F;
                outputStream.write(this.encodingTable[n3]);
                outputStream.write(this.encodingTable[n10]);
                outputStream.write(this.padding);
                outputStream.write(this.padding);
                break;
            }
            case 2: {
                int n11 = byArray[n + n5] & 0xFF;
                int n12 = byArray[n + n5 + 1] & 0xFF;
                n3 = n11 >>> 2 & 0x3F;
                int n13 = (n11 << 4 | n12 >>> 4) & 0x3F;
                int n14 = n12 << 2 & 0x3F;
                outputStream.write(this.encodingTable[n3]);
                outputStream.write(this.encodingTable[n13]);
                outputStream.write(this.encodingTable[n14]);
                outputStream.write(this.padding);
            }
        }
        return n5 / 3 * 4 + (n4 == 0 ? 0 : 4);
    }

    private boolean ignore(char c) {
        return c == '\n' || c == '\r' || c == '\t' || c == ' ';
    }

    public int decode(byte[] byArray, int n, int n2, OutputStream outputStream) throws IOException {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        int n3;
        int n4 = 0;
        for (n3 = n + n2; n3 > 0 && this.ignore((char)byArray[n3 - 1]); --n3) {
        }
        int n5 = n;
        int n6 = n3 - 4;
        while (n5 < n6) {
            while (n5 < n6 && this.ignore((char)byArray[n5])) {
                ++n5;
            }
            by4 = this.decodingTable[byArray[n5++]];
            while (n5 < n6 && this.ignore((char)byArray[n5])) {
                ++n5;
            }
            by3 = this.decodingTable[byArray[n5++]];
            while (n5 < n6 && this.ignore((char)byArray[n5])) {
                ++n5;
            }
            by2 = this.decodingTable[byArray[n5++]];
            while (n5 < n6 && this.ignore((char)byArray[n5])) {
                ++n5;
            }
            by = this.decodingTable[byArray[n5++]];
            outputStream.write(by4 << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by2 >> 2);
            outputStream.write(by2 << 6 | by);
            n4 += 3;
        }
        if (byArray[n3 - 2] == this.padding) {
            by4 = this.decodingTable[byArray[n3 - 4]];
            by3 = this.decodingTable[byArray[n3 - 3]];
            outputStream.write(by4 << 2 | by3 >> 4);
            ++n4;
        } else if (byArray[n3 - 1] == this.padding) {
            by4 = this.decodingTable[byArray[n3 - 4]];
            by3 = this.decodingTable[byArray[n3 - 3]];
            by2 = this.decodingTable[byArray[n3 - 2]];
            outputStream.write(by4 << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by2 >> 2);
            n4 += 2;
        } else {
            by4 = this.decodingTable[byArray[n3 - 4]];
            by3 = this.decodingTable[byArray[n3 - 3]];
            by2 = this.decodingTable[byArray[n3 - 2]];
            by = this.decodingTable[byArray[n3 - 1]];
            outputStream.write(by4 << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by2 >> 2);
            outputStream.write(by2 << 6 | by);
            n4 += 3;
        }
        return n4;
    }

    public int decode(String string, OutputStream outputStream) throws IOException {
        byte by;
        byte by2;
        byte by3;
        byte by4;
        int n;
        int n2 = 0;
        for (n = string.length(); n > 0 && this.ignore(string.charAt(n - 1)); --n) {
        }
        int n3 = 0;
        int n4 = n - 4;
        while (n3 < n4) {
            while (n3 < n4 && this.ignore(string.charAt(n3))) {
                ++n3;
            }
            by4 = this.decodingTable[string.charAt(n3++)];
            while (n3 < n4 && this.ignore(string.charAt(n3))) {
                ++n3;
            }
            by3 = this.decodingTable[string.charAt(n3++)];
            while (n3 < n4 && this.ignore(string.charAt(n3))) {
                ++n3;
            }
            by2 = this.decodingTable[string.charAt(n3++)];
            while (n3 < n4 && this.ignore(string.charAt(n3))) {
                ++n3;
            }
            by = this.decodingTable[string.charAt(n3++)];
            outputStream.write(by4 << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by2 >> 2);
            outputStream.write(by2 << 6 | by);
            n2 += 3;
        }
        if (string.charAt(n - 2) == this.padding) {
            by4 = this.decodingTable[string.charAt(n - 4)];
            by3 = this.decodingTable[string.charAt(n - 3)];
            outputStream.write(by4 << 2 | by3 >> 4);
            ++n2;
        } else if (string.charAt(n - 1) == this.padding) {
            by4 = this.decodingTable[string.charAt(n - 4)];
            by3 = this.decodingTable[string.charAt(n - 3)];
            by2 = this.decodingTable[string.charAt(n - 2)];
            outputStream.write(by4 << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by2 >> 2);
            n2 += 2;
        } else {
            by4 = this.decodingTable[string.charAt(n - 4)];
            by3 = this.decodingTable[string.charAt(n - 3)];
            by2 = this.decodingTable[string.charAt(n - 2)];
            by = this.decodingTable[string.charAt(n - 1)];
            outputStream.write(by4 << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by2 >> 2);
            outputStream.write(by2 << 6 | by);
            n2 += 3;
        }
        return n2;
    }
}

