/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.contrib.nanoxml.XMLElement;
import com.l2fprod.gui.border.LineBorder;
import com.l2fprod.gui.plaf.skin.CompoundSkin;
import com.l2fprod.gui.plaf.skin.IncorrectVersionException;
import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinButtonUI;
import com.l2fprod.gui.plaf.skin.SkinCheckBoxIcon;
import com.l2fprod.gui.plaf.skin.SkinCheckBoxMenuItemUI;
import com.l2fprod.gui.plaf.skin.SkinCheckBoxUI;
import com.l2fprod.gui.plaf.skin.SkinComboBoxUI;
import com.l2fprod.gui.plaf.skin.SkinDesktopIconUI;
import com.l2fprod.gui.plaf.skin.SkinDesktopPaneUI;
import com.l2fprod.gui.plaf.skin.SkinFileChooserUI;
import com.l2fprod.gui.plaf.skin.SkinInternalFrameUI;
import com.l2fprod.gui.plaf.skin.SkinMenuBarUI;
import com.l2fprod.gui.plaf.skin.SkinMenuItemUI;
import com.l2fprod.gui.plaf.skin.SkinMenuUI;
import com.l2fprod.gui.plaf.skin.SkinOptionPaneUI;
import com.l2fprod.gui.plaf.skin.SkinPanelUI;
import com.l2fprod.gui.plaf.skin.SkinPopupMenuUI;
import com.l2fprod.gui.plaf.skin.SkinProgressBarUI;
import com.l2fprod.gui.plaf.skin.SkinRadioButtonMenuItemUI;
import com.l2fprod.gui.plaf.skin.SkinRadioButtonUI;
import com.l2fprod.gui.plaf.skin.SkinRootPaneUI;
import com.l2fprod.gui.plaf.skin.SkinScrollBarUI;
import com.l2fprod.gui.plaf.skin.SkinSeparatorUI;
import com.l2fprod.gui.plaf.skin.SkinSliderUI;
import com.l2fprod.gui.plaf.skin.SkinSplitPaneUI;
import com.l2fprod.gui.plaf.skin.SkinTabbedPaneUI;
import com.l2fprod.gui.plaf.skin.SkinTableHeaderUI;
import com.l2fprod.gui.plaf.skin.SkinToggleButtonUI;
import com.l2fprod.gui.plaf.skin.SkinToolBarSeparatorUI;
import com.l2fprod.gui.plaf.skin.SkinToolBarUI;
import com.l2fprod.gui.plaf.skin.SkinToolTipUI;
import com.l2fprod.gui.plaf.skin.SkinTreeUI;
import com.l2fprod.gui.plaf.skin.SkinUtils;
import com.l2fprod.gui.plaf.skin.SkinWindowButtonUI;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkSkin;
import com.l2fprod.gui.plaf.skin.impl.kde.KdeSkin;
import com.l2fprod.util.OS;
import com.l2fprod.util.StringUtils;
import com.l2fprod.util.ZipResourceLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.text.JTextComponent;

public class SkinLookAndFeel
extends BasicLookAndFeel {
    public static final String VERSION = SkinLookAndFeel.version();
    private static Skin c_CurrentSkin;
    private static ZipResourceLoader c_ResourceLoader;

    public static String version() {
        return "1.2.10";
    }

    public static String date() {
        return "08/13/2004 09:30 PM";
    }

    public SkinLookAndFeel() {
        UIManager.getLookAndFeelDefaults().put("ClassLoader", this.getClass().getClassLoader());
    }

    public String getName() {
        return "SkinLF";
    }

    public String getDescription() {
        return "Skin Look and Feel";
    }

    public String getID() {
        return "SkinLF";
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean getSupportsWindowDecorations() {
        return true;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        Vector<Object> vector = new Vector<Object>();
        if (SkinLookAndFeel.getSkin().getProgress() != null && SkinLookAndFeel.getSkin().getProgress().status()) {
            vector.addElement("ProgressBarUI");
            vector.addElement(SkinProgressBarUI.class.getName());
        }
        if (SkinLookAndFeel.getSkin().getTab() != null && SkinLookAndFeel.getSkin().getTab().status()) {
            vector.addElement("TabbedPaneUI");
            vector.addElement(SkinTabbedPaneUI.class.getName());
        }
        if (SkinLookAndFeel.getSkin().getFrame() != null && SkinLookAndFeel.getSkin().getFrame().status()) {
            vector.addElement("InternalFrameUI");
            vector.addElement(SkinInternalFrameUI.class.getName());
            if (OS.isOneDotFourOrMore()) {
                vector.addElement("RootPaneUI");
                vector.addElement(SkinRootPaneUI.class.getName());
            }
            vector.addElement("WindowButtonUI");
            vector.addElement(SkinWindowButtonUI.class.getName());
        }
        if (SkinLookAndFeel.getSkin().getSlider() != null && SkinLookAndFeel.getSkin().getSlider().status()) {
            vector.addElement("SliderUI");
            vector.addElement(SkinSliderUI.class.getName());
        }
        if (SkinLookAndFeel.getSkin().getScrollbar() != null && SkinLookAndFeel.getSkin().getScrollbar().status()) {
            vector.addElement("ScrollBarUI");
            vector.addElement(SkinScrollBarUI.class.getName());
        }
        if (SkinLookAndFeel.getSkin().getButton() != null && SkinLookAndFeel.getSkin().getButton().status()) {
            vector.addElement("ButtonUI");
            vector.addElement(SkinButtonUI.class.getName());
            vector.addElement("ToggleButtonUI");
            vector.addElement(SkinToggleButtonUI.class.getName());
        }
        if (SkinLookAndFeel.getSkin().getSeparator() != null && SkinLookAndFeel.getSkin().getSeparator().status()) {
            vector.addElement("SeparatorUI");
            vector.addElement(SkinSeparatorUI.class.getName());
        }
        Object[] objectArray = new Object[]{"CheckBoxUI", SkinCheckBoxUI.class.getName(), "ComboBoxUI", SkinComboBoxUI.class.getName(), "CheckBoxMenuItemUI", SkinCheckBoxMenuItemUI.class.getName(), "MenuItemUI", SkinMenuItemUI.class.getName(), "MenuUI", SkinMenuUI.class.getName(), "MenuBarUI", SkinMenuBarUI.class.getName(), "ToolBarUI", SkinToolBarUI.class.getName(), "ToolBarSeparatorUI", SkinToolBarSeparatorUI.class.getName(), "PopupMenuUI", SkinPopupMenuUI.class.getName(), "RadioButtonUI", SkinRadioButtonUI.class.getName(), "RadioButtonMenuItemUI", SkinRadioButtonMenuItemUI.class.getName(), "PanelUI", SkinPanelUI.class.getName(), "DesktopPaneUI", SkinDesktopPaneUI.class.getName(), "DesktopIconUI", SkinDesktopIconUI.class.getName(), "TableHeaderUI", SkinTableHeaderUI.class.getName(), "FileChooserUI", SkinFileChooserUI.class.getName(), "TextFieldUI", "javax.swing.plaf.metal.MetalTextFieldUI", "SplitPaneUI", Boolean.TRUE.equals(UIManager.get("JSplitPane.alternateUI")) ? SkinSplitPaneUI.class.getName() : "javax.swing.plaf.basic.BasicSplitPaneUI", "TreeUI", SkinTreeUI.class.getName(), "OptionPaneUI", SkinOptionPaneUI.class.getName(), "ToolTipUI", SkinToolTipUI.class.getName()};
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        Object[] objectArray2 = new Object[vector.size()];
        vector.copyInto(objectArray2);
        uIDefaults.putDefaults(objectArray2);
    }

    protected void initSystemColorDefaults(UIDefaults uIDefaults) {
        super.initSystemColorDefaults(uIDefaults);
        String[] stringArray = SkinLookAndFeel.getSkin().getColors();
        if (stringArray != null) {
            this.loadSystemColors(uIDefaults, stringArray, this.isNativeLookAndFeel());
        } else {
            this.loadSystemColors(uIDefaults, new String[0], this.isNativeLookAndFeel());
        }
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        this.loadResourceBundle(uIDefaults);
        Icon icon = SkinTreeUI.ExpandedIcon.createExpandedIcon();
        Icon icon2 = SkinTreeUI.CollapsedIcon.createCollapsedIcon();
        SkinCheckBoxIcon skinCheckBoxIcon = new SkinCheckBoxIcon();
        BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(new EmptyBorder(2, 3, 3, 3), new BasicBorders.MarginBorder());
        Object[] objectArray = new Object[]{"Button.dashedRectGapX", new Integer(5), "Button.dashedRectGapY", new Integer(4), "Button.dashedRectGapWidth", new Integer(10), "Button.dashedRectGapHeight", new Integer(8), "Button.textShiftOffset", new Integer(1), "Button.border", compoundBorderUIResource, "Desktop.background", uIDefaults.get("desktop"), "ToggleButton.textShiftOffset", new Integer(1), "CheckBoxMenuItem.checkIcon", skinCheckBoxIcon, "RadioButtonMenuItem.checkIcon", skinCheckBoxIcon, "SplitPane.dividerSize", new Integer(4), "SplitPane.background", uIDefaults.get("control"), "ProgressBar.cellLength", new Integer(7), "ProgressBar.cellSpacing", new Integer(2), "Tree.expandedIcon", icon, "Tree.collapsedIcon", icon2, "Tree.line", Color.black, "Tree.hash", Color.black, "Tree.rowHeight", new Integer(0), "Tree.textForeground", uIDefaults.get("textText"), "Tree.textBackground", uIDefaults.get("window"), "FileChooser.lookInLabelMnemonic", new Integer(73), "FileChooser.fileNameLabelMnemonic", new Integer(78), "FileChooser.filesOfTypeLabelMnemonic", new Integer(84), "InternalFrame.minimizeIconBackground", uIDefaults.get("control"), "InternalFrame.resizeIconHighlight", uIDefaults.get("controlHighlight"), "InternalFrame.resizeIconShadow", uIDefaults.get("controlShadow"), "ToolBar.separatorSize", null};
        uIDefaults.putDefaults(objectArray);
        try {
            Class.forName("javax.swing.InputMap");
            Class<?> clazz = Class.forName("javax.swing.UIDefaults");
            Class<?>[] classArray = clazz.getClasses();
            Constructor<?> constructor = null;
            for (int i = 0; i < classArray.length; ++i) {
                if (!classArray[i].getName().endsWith("LazyInputMap")) continue;
                constructor = classArray[i].getConstructor(Object[].class);
                break;
            }
            Object[] objectArray2 = new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"};
            Object[] objectArray3 = new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"};
            uIDefaults.put("TextField.focusInputMap", constructor.newInstance(new Object[]{objectArray2}));
            uIDefaults.put("PasswordField.focusInputMap", constructor.newInstance(new Object[]{objectArray2}));
            uIDefaults.put("TextArea.focusInputMap", constructor.newInstance(new Object[]{objectArray3}));
            uIDefaults.put("TextPane.focusInputMap", constructor.newInstance(new Object[]{objectArray3}));
            uIDefaults.put("EditorPane.focusInputMap", constructor.newInstance(new Object[]{objectArray3}));
        }
        catch (Throwable throwable) {
            JTextComponent.KeyBinding[] keyBindingArray = SkinLookAndFeel.makeKeyBindings(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"});
            JTextComponent.KeyBinding[] keyBindingArray2 = SkinLookAndFeel.makeKeyBindings(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "control A", "select-all", "control BACK_SLASH", "unselect", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "control HOME", "caret-begin", "control END", "caret-end", "control shift HOME", "selection-begin", "control shift END", "selection-end", "UP", "caret-up", "DOWN", "caret-down", "BACK_SPACE", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "control shift PAGE_UP", "selection-page-left", "control shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift DOWN", "selection-down", "ENTER", "insert-break", "TAB", "insert-tab", "control T", "next-link-action", "control shift T", "previous-link-action", "control SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
            uIDefaults.put("TextField.keyBindings", keyBindingArray);
            uIDefaults.put("PasswordField.keyBindings", keyBindingArray);
            uIDefaults.put("TextArea.keyBindings", keyBindingArray2);
            uIDefaults.put("TextPane.keyBindings", keyBindingArray2);
            uIDefaults.put("EditorPane.keyBindings", keyBindingArray2);
        }
    }

    private void loadResourceBundle(UIDefaults uIDefaults) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.l2fprod.gui.plaf.skin.resources.skin");
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            uIDefaults.put(string, resourceBundle.getObject(string));
        }
    }

    public static void setSkin(Skin skin) {
        c_CurrentSkin = skin;
    }

    public static Skin getSkin() {
        Skin skin = c_CurrentSkin;
        if (skin == null) {
            try {
                String string = System.getProperty("skinlf.themepack");
                if (string != null) {
                    skin = SkinLookAndFeel.loadThemePack(string);
                } else {
                    File file = new File(System.getProperty("user.home") + File.separator + ".skinlf" + File.separator + "themepack.zip");
                    if (!file.isFile()) {
                        file = new File(System.getProperty("user.home") + File.separator + "skinlf" + File.separator + "themepack.zip");
                    }
                    if (file.isFile()) {
                        skin = SkinLookAndFeel.loadThemePack(file.toURL());
                    } else {
                        URL uRL = SkinLookAndFeel.class.getResource("/themepack.zip");
                        if (uRL != null) {
                            skin = SkinLookAndFeel.loadThemePack(uRL);
                        } else {
                            throw new Error("themepack.zip not found in classpath");
                        }
                    }
                }
                SkinLookAndFeel.setSkin(skin);
            }
            catch (Throwable throwable) {
                throw new Error("Skin was null and an error occurs while trying to load the user theme pack. Source exception message is " + throwable.getMessage());
            }
        }
        return skin;
    }

    public static void enable() throws UnsupportedLookAndFeelException {
        SkinLookAndFeel skinLookAndFeel = new SkinLookAndFeel();
        UIManager.setLookAndFeel(skinLookAndFeel);
        UIManager.getLookAndFeelDefaults().put("ClassLoader", skinLookAndFeel.getClass().getClassLoader());
    }

    public static Skin loadSkin(String string) throws Exception {
        return SkinLookAndFeel.loadSkin(SkinUtils.toURL((File)new File(string)));
    }

    public static Skin loadSkin(URL uRL) throws Exception {
        String string = uRL.getFile();
        if (string.endsWith("gtkrc")) {
            return new GtkSkin(uRL, SkinLookAndFeel.getInputStream(uRL));
        }
        if (string.endsWith(".themerc")) {
            return new KdeSkin(uRL, SkinLookAndFeel.getInputStream(uRL));
        }
        throw new Exception("Unable to load this skin " + uRL + " (by using filename matching), " + " try an explicit constructor");
    }

    public static Skin loadDefaultThemePack() throws Exception {
        return SkinLookAndFeel.loadThemePackDefinition(SkinLookAndFeel.class.getResource("/skinlf-themepack.xml"));
    }

    public static Skin loadThemePack(String string) throws Exception {
        if (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("ftp://") || string.startsWith("file:/") || string.startsWith("jar:/")) {
            return SkinLookAndFeel.loadThemePack(new URL(string));
        }
        return SkinLookAndFeel.loadThemePack(SkinUtils.toURL((File)new File(string)));
    }

    public static Skin loadThemePack(URL uRL) throws Exception {
        return SkinLookAndFeel.loadThemePack(uRL.openStream());
    }

    public static Skin loadThemePack(InputStream inputStream) throws Exception {
        ZipResourceLoader zipResourceLoader;
        c_ResourceLoader = zipResourceLoader = new ZipResourceLoader(inputStream);
        Skin skin = SkinLookAndFeel.loadThemePackDefinition(new URL("http://dummyhostforziploader/skinlf-themepack.xml"));
        c_ResourceLoader = null;
        return skin;
    }

    public static Skin loadThemePackDefinition(URL uRL) throws Exception {
        Skin skin = null;
        XMLElement xMLElement = new XMLElement();
        xMLElement.parseFromReader((Reader)new InputStreamReader(SkinLookAndFeel.getInputStream(uRL)));
        SkinLookAndFeel.checkRequiredVersion(xMLElement.getProperty("REQUIRE"));
        UIManager.put("JDesktopPane.backgroundEnabled", Boolean.FALSE);
        UIManager.put("PopupMenu.animation", Boolean.FALSE);
        UIManager.put("ScrollBar.alternateLayout", Boolean.FALSE);
        UIManager.put("JSplitPane.alternateUI", Boolean.FALSE);
        Enumeration enumeration = xMLElement.enumerateChildren();
        while (enumeration.hasMoreElements()) {
            Object object;
            xMLElement = (XMLElement)enumeration.nextElement();
            String string = xMLElement.getTagName().toLowerCase();
            if ("skin".equals(string)) {
                skin = SkinLookAndFeel.buildSkin(uRL, xMLElement);
                continue;
            }
            if ("property".equals(string)) {
                Serializable serializable;
                object = xMLElement.getProperty("TYPE");
                if (object == null || "".equals(object) || "boolean".equalsIgnoreCase((String)object) || "java.lang.Boolean".equalsIgnoreCase((String)object)) {
                    UIManager.put(xMLElement.getProperty("NAME"), Boolean.valueOf(xMLElement.getProperty("VALUE")));
                    continue;
                }
                if ("int".equalsIgnoreCase((String)object) || "java.lang.Integer".equalsIgnoreCase((String)object)) {
                    UIManager.put(xMLElement.getProperty("NAME"), Integer.valueOf(xMLElement.getProperty("VALUE")));
                    continue;
                }
                if ("String".equalsIgnoreCase((String)object) || "java.lang.String".equalsIgnoreCase((String)object)) {
                    UIManager.put(xMLElement.getProperty("NAME"), xMLElement.getProperty("VALUE"));
                    continue;
                }
                if ("Color".equalsIgnoreCase((String)object) || "java.awt.Color".equalsIgnoreCase((String)object)) {
                    Color color = Color.decode(xMLElement.getProperty("VALUE"));
                    UIManager.put(xMLElement.getProperty("NAME"), new ColorUIResource(color));
                    continue;
                }
                if ("Insets".equalsIgnoreCase((String)object) || "java.awt.Insets".equalsIgnoreCase((String)object)) {
                    Insets insets = SkinLookAndFeel.parseInsets(xMLElement.getProperty("VALUE"));
                    UIManager.put(xMLElement.getProperty("NAME"), new InsetsUIResource(insets.top, insets.left, insets.bottom, insets.right));
                    continue;
                }
                if ("Dimension".equalsIgnoreCase((String)object) || "java.awt.Dimension".equalsIgnoreCase((String)object)) {
                    Dimension dimension = SkinLookAndFeel.parseDimension(xMLElement.getProperty("VALUE"));
                    UIManager.put(xMLElement.getProperty("NAME"), new DimensionUIResource(dimension.width, dimension.height));
                    continue;
                }
                if ("LineBorder".equalsIgnoreCase((String)object) || "javax.swing.border.LineBorder".equalsIgnoreCase((String)object)) {
                    boolean bl = false;
                    serializable = Color.black;
                    int n = 1;
                    int n2 = 0;
                    String string2 = xMLElement.getProperty("ROUNDED");
                    if (string2 != null) {
                        bl = Boolean.getBoolean(string2);
                    }
                    if ((string2 = xMLElement.getProperty("THICKNESS")) != null) {
                        n = Integer.parseInt(string2);
                    }
                    if ((string2 = xMLElement.getProperty("PADDING")) != null) {
                        n2 = Integer.parseInt(string2);
                    }
                    if ((string2 = xMLElement.getProperty("COLOR")) != null) {
                        serializable = Color.decode(string2);
                    }
                    Object object2 = new LineBorder(serializable, n, bl);
                    if (n2 > 0) {
                        object2 = new CompoundBorder((Border)object2, BorderFactory.createEmptyBorder(n2, n2, n2, n2));
                    }
                    UIManager.put(xMLElement.getProperty("NAME"), new BorderUIResource((Border)object2));
                    continue;
                }
                if (!"EmptyBorder".equalsIgnoreCase((String)object) && !"javax.swing.border.EmptyBorder".equalsIgnoreCase((String)object)) continue;
                Insets insets = SkinLookAndFeel.parseInsets(xMLElement.getProperty("VALUE"));
                serializable = new EmptyBorder(insets);
                UIManager.put(xMLElement.getProperty("NAME"), new BorderUIResource((Border)((Object)serializable)));
                continue;
            }
            if ("font".equalsIgnoreCase(string)) {
                object = StringUtils.splitString((String)xMLElement.getProperty("VALUE"), (String)",");
                Font font = SkinUtils.getFont((String)object[0], (int)Integer.parseInt(object[1]), (int)Integer.parseInt(object[2]));
                if (font == null) continue;
                if ("Global".equalsIgnoreCase(xMLElement.getProperty("NAME"))) {
                    SkinUtils.setFont((Font)new FontUIResource(font));
                    continue;
                }
                UIManager.put(xMLElement.getProperty("NAME"), new FontUIResource(font));
                continue;
            }
            if (!"icon".equalsIgnoreCase(string)) continue;
            object = new URL(uRL, xMLElement.getProperty("VALUE"));
            ImageIcon imageIcon = new ImageIcon(SkinUtils.loadImage((URL)object));
            UIManager.put(xMLElement.getProperty("NAME"), new IconUIResource(imageIcon));
            if (!"InternalFrame.icon".equals(xMLElement.getProperty("NAME"))) continue;
            JOptionPane.getRootFrame().setIconImage(imageIcon.getImage());
        }
        return skin;
    }

    public static void checkRequiredVersion(String string) throws IncorrectVersionException {
        if (string == null || "".equals(string)) {
            return;
        }
        IncorrectVersionException.checkRequiredVersion((String)SkinLookAndFeel.version(), (String)string);
    }

    static InputStream getInputStream(URL uRL) throws Exception {
        if (c_ResourceLoader != null) {
            return c_ResourceLoader.getZipResource(uRL).getInputStream();
        }
        return uRL.openStream();
    }

    static byte[] getURLContent(URL uRL) throws Exception {
        if (c_ResourceLoader == null) {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = bufferedInputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            return byteArrayOutputStream.toByteArray();
        }
        return c_ResourceLoader.getZipResource(uRL).getURLContent();
    }

    private static Dimension parseDimension(String string) {
        int[] nArray = new int[2];
        Arrays.fill(nArray, 0);
        String[] stringArray = StringUtils.splitString((String)string, (String)"{,}");
        for (int i = 0; i < 4; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return new Dimension(nArray[0], nArray[1]);
    }

    private static Insets parseInsets(String string) {
        int[] nArray = new int[4];
        Arrays.fill(nArray, 0);
        String[] stringArray = StringUtils.splitString((String)string, (String)"{,}");
        for (int i = 0; i < 4; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return new Insets(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    private static Skin buildSkin(URL uRL, XMLElement xMLElement) throws Exception {
        Skin skin = null;
        if (xMLElement.countChildren() == 0) {
            skin = SkinLookAndFeel.loadSkin(new URL(uRL, xMLElement.getProperty("URL")));
        } else if (xMLElement.countChildren() == 2) {
            skin = new CompoundSkin(SkinLookAndFeel.buildSkin(uRL, (XMLElement)xMLElement.getChildren().elementAt(0)), SkinLookAndFeel.buildSkin(uRL, (XMLElement)xMLElement.getChildren().elementAt(1)));
        }
        return skin;
    }
}

