/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class SkinButtonUI
extends BasicButtonUI {
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    protected Skin skin = SkinLookAndFeel.getSkin();
    private boolean defaults_initialized = false;
    static final SkinButtonUI buttonUI = new SkinButtonUI();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        SkinButtonUI.viewRect.x = insets.left;
        SkinButtonUI.viewRect.y = insets.top;
        SkinButtonUI.viewRect.width = abstractButton.getWidth() - (insets.right + SkinButtonUI.viewRect.x);
        SkinButtonUI.viewRect.height = abstractButton.getHeight() - (insets.bottom + SkinButtonUI.viewRect.y);
        SkinButtonUI.textRect.height = 0;
        SkinButtonUI.textRect.width = 0;
        SkinButtonUI.textRect.y = 0;
        SkinButtonUI.textRect.x = 0;
        SkinButtonUI.iconRect.height = 0;
        SkinButtonUI.iconRect.width = 0;
        SkinButtonUI.iconRect.y = 0;
        SkinButtonUI.iconRect.x = 0;
        Font font = jComponent.getFont();
        graphics.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : this.defaultTextIconGap);
        this.clearTextShiftOffset();
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        this.skin.getButton().paintButton(graphics, abstractButton);
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics, jComponent, iconRect);
        }
        if (string != null && !string.equals("")) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else {
                this.paintText(graphics, jComponent, textRect, string);
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, viewRect, textRect, iconRect);
        }
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            String string = this.getPropertyPrefix();
            this.dashedRectGapX = UIManager.getInt(string + "dashedRectGapX");
            this.dashedRectGapY = UIManager.getInt(string + "dashedRectGapY");
            this.dashedRectGapWidth = UIManager.getInt(string + "dashedRectGapWidth");
            this.dashedRectGapHeight = UIManager.getInt(string + "dashedRectGapHeight");
            this.focusColor = UIManager.getColor(string + "focus");
            this.defaults_initialized = true;
        }
        this.skin.getButton().installSkin((JComponent)abstractButton);
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        int n = abstractButton.getWidth();
        int n2 = abstractButton.getHeight();
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, this.dashedRectGapX, this.dashedRectGapY, n - this.dashedRectGapWidth, n2 - this.dashedRectGapHeight);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        this.setTextShiftOffset();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        SkinButtonUI.buttonUI.skin = SkinLookAndFeel.getSkin();
        SkinButtonUI.buttonUI.defaults_initialized = false;
        return buttonUI;
    }
}

