/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model.gui;

import frost.util.model.gui.ModelTableHeader;
import frost.util.model.gui.SortedModelTable;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class SortedTableHeader
extends ModelTableHeader {
    private static Logger logger = Logger.getLogger(SortedTableHeader.class.getName());
    private static Icon ascendingIcon;
    private static Icon descendingIcon;
    private ArrowRenderer arrowRenderer = new ArrowRenderer();
    private SortedModelTable sortedTable;

    public SortedTableHeader(SortedModelTable sortedModelTable) {
        super(sortedModelTable);
        this.sortedTable = sortedModelTable;
        Enumeration<TableColumn> enumeration = this.sortedTable.getTable().getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            tableColumn.setHeaderRenderer(this.arrowRenderer);
        }
    }

    protected void headerClicked(MouseEvent mouseEvent) {
        TableColumnModel tableColumnModel;
        int n;
        super.headerClicked(mouseEvent);
        if (mouseEvent.getButton() == 1 && (n = (tableColumnModel = this.getTable().getColumnModel()).getColumnIndexAtX(mouseEvent.getX())) != -1) {
            int n2 = tableColumnModel.getColumn(n).getModelIndex();
            this.sortedTable.columnClicked(n2);
        }
    }

    static {
        URL uRL = SortedModelTable.class.getResource("/data/SortedTable_ascending.png");
        if (uRL != null) {
            ascendingIcon = new ImageIcon(uRL);
        } else {
            logger.severe("Could not load /data/SortedTable_ascending.png icon.");
        }
        URL uRL2 = SortedModelTable.class.getResource("/data/SortedTable_descending.png");
        if (uRL2 != null) {
            descendingIcon = new ImageIcon(uRL2);
        } else {
            logger.severe("Could not load /data/SortedTable_descending.png icon.");
        }
    }

    private class ArrowRenderer
    implements TableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
            if (tableCellRenderer instanceof JLabel) {
                JLabel jLabel = (JLabel)((Object)tableCellRenderer);
                int n3 = jTable.getColumnModel().getColumn(n2).getModelIndex();
                if (SortedTableHeader.this.sortedTable.getCurrentColumnNumber() == n3) {
                    if (SortedTableHeader.this.sortedTable.isAscending()) {
                        jLabel.setIcon(ascendingIcon);
                    } else {
                        jLabel.setIcon(descendingIcon);
                    }
                    jLabel.setHorizontalTextPosition(10);
                } else {
                    jLabel.setIcon(null);
                }
            }
            return tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

