/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model.gui;

import frost.util.gui.SwingWorker;
import frost.util.model.ModelItem;
import frost.util.model.OrderedModel;
import frost.util.model.gui.ModelTable;
import frost.util.model.gui.SortedModel;
import frost.util.model.gui.SortedTableFormat;
import frost.util.model.gui.SortedTableHeader;
import java.util.logging.Logger;

public class SortedModelTable
extends ModelTable {
    private static Logger logger = Logger.getLogger(SortedModelTable.class.getName());
    private int currentColumnNumber = -1;
    private boolean ascending;

    public SortedModelTable(OrderedModel orderedModel, SortedTableFormat sortedTableFormat) {
        super(sortedTableFormat);
        SortedModel sortedModel = new SortedModel(orderedModel, sortedTableFormat);
        this.setModel(sortedModel);
        this.initialize();
        this.getTable().setTableHeader(new SortedTableHeader(this));
    }

    void columnClicked(int n) {
        if (n != this.currentColumnNumber) {
            this.currentColumnNumber = n;
            this.ascending = true;
        } else {
            this.ascending = !this.ascending;
        }
        final int n2 = n;
        SwingWorker swingWorker = new SwingWorker(this.table){

            protected void doNonUILogic() throws RuntimeException {
                int n = SortedModelTable.this.convertColumnIndexToFormat(n2);
                ((SortedModel)SortedModelTable.this.model).sort(n, SortedModelTable.this.ascending);
            }

            protected void doUIUpdateLogic() throws RuntimeException {
                SortedModelTable.this.table.revalidate();
                SortedModelTable.this.table.repaint();
            }
        };
        swingWorker.start();
    }

    int getCurrentColumnNumber() {
        return this.currentColumnNumber;
    }

    boolean isAscending() {
        return this.ascending;
    }

    public ModelItem getItemAt(int n) {
        return this.model.getItemAt(n);
    }

    public void setColumnVisible(int n, boolean bl) {
        super.setColumnVisible(n, bl);
        if (!bl) {
            if (n == this.currentColumnNumber) {
                this.currentColumnNumber = -1;
            } else if (n < this.currentColumnNumber) {
                --this.currentColumnNumber;
            }
        }
    }
}

