/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model.gui;

import frost.util.model.ModelItem;
import frost.util.model.OrderedModel;
import frost.util.model.OrderedModelListener;
import frost.util.model.gui.SortedTableFormat;
import java.util.Collections;
import java.util.Comparator;

public class SortedModel
extends OrderedModel {
    private boolean ascending;
    private int columnNumber = -1;
    private SortedTableFormat tableFormat;
    private OrderedModel sourceModel;
    private Listener listener = new Listener();

    public SortedModel(OrderedModel orderedModel, SortedTableFormat sortedTableFormat) {
        this.sourceModel = orderedModel;
        this.tableFormat = sortedTableFormat;
        for (int i = 0; i < this.sourceModel.getItemCount(); ++i) {
            this.addItem(this.sourceModel.getItemAt(i));
        }
        this.sourceModel.addOrderedModelListener(this.listener);
    }

    protected void sort(int n, boolean bl) {
        this.columnNumber = n;
        this.ascending = bl;
        Collections.sort(this.data, this.getComparator());
    }

    private Comparator getComparator() {
        if (this.ascending) {
            return this.tableFormat.getComparator(this.columnNumber);
        }
        return this.tableFormat.getReverseComparator(this.columnNumber);
    }

    private int getInsertionPoint(ModelItem modelItem) {
        int n = Collections.binarySearch(this.data, modelItem, this.getComparator());
        if (n < 0) {
            n = (n + 1) * -1;
        } else {
            n = Collections.lastIndexOfSubList(this.data, Collections.singletonList(this.data.get(n)));
            ++n;
        }
        return n;
    }

    private void reinsertItem(ModelItem modelItem) {
        this.removeItems(new ModelItem[]{modelItem});
        this.addItem(modelItem, this.getInsertionPoint(modelItem));
    }

    private class Listener
    implements OrderedModelListener {
        private Listener() {
        }

        public void itemChanged(int n, ModelItem modelItem, int n2, Object object, Object object2) {
            if (SortedModel.this.columnNumber == -1) {
                SortedModel.this.fireItemChanged(modelItem, n2, object, object2);
            } else {
                SortedModel.this.reinsertItem(modelItem);
            }
        }

        public void itemChanged(int n, ModelItem modelItem) {
            if (SortedModel.this.columnNumber == -1) {
                SortedModel.this.fireItemChanged(modelItem);
            } else {
                SortedModel.this.reinsertItem(modelItem);
            }
        }

        public void itemAdded(int n, ModelItem modelItem) {
            if (SortedModel.this.columnNumber == -1) {
                SortedModel.this.addItem(modelItem);
            } else {
                SortedModel.this.addItem(modelItem, SortedModel.this.getInsertionPoint(modelItem));
            }
        }

        public void itemsRemoved(int[] nArray, ModelItem[] modelItemArray) {
            SortedModel.this.removeItems(modelItemArray);
        }

        public void modelCleared() {
            SortedModel.this.clear();
        }
    }
}

