/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model.gui;

import frost.util.model.gui.ModelTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class ModelTableHeader
extends JTableHeader {
    private Listener listener = new Listener();
    private ModelTable modelTable;
    private ColumnsPopupMenu popup;

    public ModelTableHeader(ModelTable modelTable) {
        super(modelTable.getTable().getColumnModel());
        this.modelTable = modelTable;
        this.addMouseListener(this.listener);
    }

    protected void headerClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected void headerReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void popupMenu_actionPerformed(int n) {
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.popup.getComponent(n);
        if (jCheckBoxMenuItem.isSelected()) {
            this.modelTable.setColumnVisible(n, true);
        } else {
            this.modelTable.setColumnVisible(n, false);
        }
    }

    private JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new ColumnsPopupMenu();
        }
        return this.popup;
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener {
        public void mouseClicked(MouseEvent mouseEvent) {
            ModelTableHeader.this.headerClicked(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ModelTableHeader.this.headerReleased(mouseEvent);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (ModelTableHeader.this.popup != null && (n = ModelTableHeader.this.popup.getComponentIndex((Component)actionEvent.getSource())) != -1) {
                ModelTableHeader.this.popupMenu_actionPerformed(n);
            }
        }
    }

    private class ColumnsPopupMenu
    extends JPopupMenu {
        private ColumnsPopupMenu() {
        }

        public void show(Component component, int n, int n2) {
            this.removeAll();
            Iterator iterator = ModelTableHeader.this.modelTable.getColumns();
            int n3 = 0;
            int n4 = 0;
            JMenuItem jMenuItem = null;
            while (iterator.hasNext()) {
                TableColumn tableColumn = (TableColumn)iterator.next();
                JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(tableColumn.getIdentifier().toString());
                if (ModelTableHeader.this.modelTable.isColumnVisible(n3)) {
                    jCheckBoxMenuItem.setSelected(true);
                    ++n4;
                    jMenuItem = jCheckBoxMenuItem;
                } else {
                    jCheckBoxMenuItem.setSelected(false);
                }
                jCheckBoxMenuItem.addActionListener(ModelTableHeader.this.listener);
                this.add(jCheckBoxMenuItem);
                ++n3;
            }
            if (n4 == 1) {
                jMenuItem.setEnabled(false);
            }
            super.show(component, n, n2);
        }
    }
}

