/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model.gui;

import frost.util.model.ModelItem;
import frost.util.model.OrderedModel;
import frost.util.model.OrderedModelListener;
import frost.util.model.gui.ModelTableFormat;
import java.awt.Font;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ModelTable
extends AbstractTableModel {
    private static Logger logger = Logger.getLogger(ModelTable.class.getName());
    private Listener listener = new Listener();
    protected ModelTableFormat tableFormat;
    protected OrderedModel model;
    protected JTable table;
    private JScrollPane scrollPane;
    private ArrayList visibleColumns = new ArrayList();
    private ArrayList columns = new ArrayList();

    protected ModelTable(ModelTableFormat modelTableFormat) {
        this.tableFormat = modelTableFormat;
    }

    public ModelTable(OrderedModel orderedModel, ModelTableFormat modelTableFormat) {
        this.model = orderedModel;
        this.tableFormat = modelTableFormat;
        this.initialize();
    }

    protected void initialize() {
        int n = this.tableFormat.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.visibleColumns.add(new Integer(i));
        }
        this.table = new JTable(this);
        this.scrollPane = new JScrollPane(this.table);
        this.tableFormat.addTable(this.table);
        this.tableFormat.customizeTable(this);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            this.columns.add(tableColumnModel.getColumn(i));
        }
        this.model.addOrderedModelListener(this.listener);
    }

    public int getColumnCount() {
        return this.visibleColumns.size();
    }

    public int getRowCount() {
        return this.model.getItemCount();
    }

    public Object getValueAt(int n, int n2) {
        int n3 = this.convertColumnIndexToFormat(n2);
        return this.tableFormat.getCellValue(this.model.getItemAt(n), n3);
    }

    protected void fireTableRowsDeleted(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.fireTableRowsDeleted(nArray[i], nArray[i]);
        }
    }

    public ModelItem[] getSelectedItems() {
        return new SelectionGetter().getSelectedItems();
    }

    public ModelItem getSelectedItem() {
        return new SelectionGetter().getSelectedItem();
    }

    public int getSelectedCount() {
        return this.table.getSelectedRowCount();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public String getColumnName(int n) {
        int n2 = this.convertColumnIndexToFormat(n);
        return this.tableFormat.getColumnName(n2);
    }

    public JTable getTable() {
        return this.table;
    }

    public void setFont(Font font) {
        this.table.setFont(font);
        this.table.setRowHeight(font.getSize() + 5);
    }

    public boolean isCellEditable(int n, int n2) {
        int n3 = this.convertColumnIndexToFormat(n2);
        return this.tableFormat.isColumnEditable(n3);
    }

    public boolean isColumnVisible(int n) {
        int n2 = this.convertColumnIndexToModel(n);
        return n2 != -1;
    }

    public void setColumnVisible(int n, boolean bl) {
        TableColumnModel tableColumnModel = this.getTable().getColumnModel();
        int n2 = this.convertColumnIndexToModel(n);
        if (bl) {
            if (n2 == -1) {
                this.visibleColumns.add(new Integer(n));
                TableColumn tableColumn = (TableColumn)this.columns.get(n);
                tableColumn.setModelIndex(this.visibleColumns.size() - 1);
                tableColumnModel.addColumn(tableColumn);
            }
        } else if (n2 != -1) {
            this.visibleColumns.remove(new Integer(n));
            tableColumnModel.removeColumn((TableColumn)this.columns.get(n));
            for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                int n3 = tableColumn.getModelIndex();
                if (n3 < n2) continue;
                tableColumn.setModelIndex(n3 - 1);
            }
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        int n3 = this.convertColumnIndexToFormat(n2);
        this.tableFormat.setCellValue(object, this.model.getItemAt(n), n3);
    }

    protected void setModel(OrderedModel orderedModel) {
        this.model = orderedModel;
    }

    public Iterator getColumns() {
        return this.columns.iterator();
    }

    protected int convertColumnIndexToModel(int n) {
        return this.visibleColumns.indexOf(new Integer(n));
    }

    protected int convertColumnIndexToFormat(int n) {
        Integer n2 = (Integer)this.visibleColumns.get(n);
        return n2;
    }

    protected class SelectionGetter
    implements Runnable {
        private final int MODE_SINGLE = 0;
        private final int MODE_MULTIPLE = 1;
        int mode = 0;
        ModelItem[] selectedItems;
        ModelItem selectedItem;

        protected SelectionGetter() {
        }

        public ModelItem[] getSelectedItems() {
            this.mode = 1;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (InterruptedException interruptedException) {
                    logger.log(Level.WARNING, "Exception thrown in SelectionGetter.run()", interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    logger.log(Level.WARNING, "Exception thrown in SelectionGetter.run()", invocationTargetException);
                }
            }
            return this.selectedItems;
        }

        public ModelItem getSelectedItem() {
            this.mode = 0;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (InterruptedException interruptedException) {
                    logger.log(Level.WARNING, "Exception thrown in SelectionGetter.run()", interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    logger.log(Level.WARNING, "Exception thrown in SelectionGetter.run()", invocationTargetException);
                }
            }
            return this.selectedItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            OrderedModel orderedModel = ModelTable.this.model;
            synchronized (orderedModel) {
                switch (this.mode) {
                    case 1: {
                        int n = ModelTable.this.table.getSelectedRowCount();
                        this.selectedItems = new ModelItem[n];
                        int[] nArray = ModelTable.this.table.getSelectedRows();
                        for (int i = 0; i < nArray.length; ++i) {
                            this.selectedItems[i] = ModelTable.this.model.getItemAt(nArray[i]);
                        }
                        break;
                    }
                    case 0: {
                        int n = ModelTable.this.table.getSelectedRow();
                        if (n == -1) break;
                        this.selectedItem = ModelTable.this.model.getItemAt(n);
                    }
                }
            }
        }
    }

    private class Listener
    implements OrderedModelListener {
        public void itemChanged(int n, ModelItem modelItem, int n2, Object object, Object object2) {
            int[] nArray = ModelTable.this.tableFormat.getColumnNumbers(n2);
            for (int i = 0; i < nArray.length; ++i) {
                int n3 = ModelTable.this.convertColumnIndexToModel(nArray[i]);
                ModelTable.this.fireTableCellUpdated(n, n3);
            }
        }

        public void itemChanged(int n, ModelItem modelItem) {
            ModelTable.this.fireTableRowsUpdated(n, n);
        }

        public void itemAdded(int n, ModelItem modelItem) {
            ModelTable.this.fireTableRowsInserted(n, n);
        }

        public void itemsRemoved(int[] nArray, ModelItem[] modelItemArray) {
            ModelTable.this.fireTableRowsDeleted(nArray);
        }

        public void modelCleared() {
            ModelTable.this.fireTableDataChanged();
        }
    }
}

