/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model.gui;

import frost.util.model.ModelItem;
import frost.util.model.gui.ModelTable;
import frost.util.model.gui.ModelTableFormat;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class AbstractTableFormat
implements ModelTableFormat {
    private static Logger logger = Logger.getLogger(AbstractTableFormat.class.getName());
    private int columnCount;
    private String[] columnNames;
    private boolean[] columnEditable;
    protected Vector tables;

    protected AbstractTableFormat(int n) {
        this.columnCount = n;
        this.columnNames = new String[this.columnCount];
        this.columnEditable = new boolean[this.columnCount];
        for (int i = 0; i < this.columnEditable.length; ++i) {
            this.columnEditable[i] = false;
        }
    }

    public void customizeTable(ModelTable modelTable) {
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public synchronized void addTable(JTable jTable) {
        if (this.tables == null) {
            this.tables = new Vector();
        }
        this.tables.add(jTable);
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    protected void setColumnName(int n, String string) {
        this.columnNames[n] = string;
    }

    protected synchronized void refreshColumnNames() {
        if (this.tables != null) {
            for (JTable jTable : this.tables) {
                TableColumnModel tableColumnModel = jTable.getColumnModel();
                for (int i = 0; i < jTable.getColumnCount(); ++i) {
                    TableColumn tableColumn = tableColumnModel.getColumn(i);
                    tableColumn.setHeaderValue(this.columnNames[i]);
                }
            }
        }
    }

    public boolean isColumnEditable(int n) {
        return this.columnEditable[n];
    }

    public void setColumnEditable(int n, boolean bl) {
        this.columnEditable[n] = bl;
    }

    public void setCellValue(Object object, ModelItem modelItem, int n) {
        logger.warning("The column number " + n + "is not editable.");
    }
}

