/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model;

import frost.util.model.Model;
import frost.util.model.ModelItem;
import frost.util.model.ModelListener;
import frost.util.model.ModelListenerProxy;
import java.util.Hashtable;
import java.util.Vector;

class ModelChangeSupport {
    private Model source;
    private Vector listeners;
    private Hashtable children;

    public ModelChangeSupport(Model model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.source = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemChanged(ModelItem modelItem, int n, Object object, Object object2) {
        if (object != null && object2 != null && object.equals(object2)) {
            return;
        }
        Vector vector = null;
        ModelChangeSupport modelChangeSupport = null;
        ModelChangeSupport modelChangeSupport2 = this;
        synchronized (modelChangeSupport2) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
            if (this.children != null) {
                modelChangeSupport = (ModelChangeSupport)this.children.get(new Integer(n));
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ModelListener modelListener = (ModelListener)vector.elementAt(i);
                modelListener.itemChanged(modelItem, n, object, object2);
            }
        }
        if (modelChangeSupport != null) {
            modelChangeSupport.fireItemChanged(modelItem, n, object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemChanged(ModelItem modelItem) {
        Vector vector = null;
        ModelChangeSupport modelChangeSupport = this;
        synchronized (modelChangeSupport) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ModelListener modelListener = (ModelListener)vector.elementAt(i);
                modelListener.itemChanged(modelItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemAdded(ModelItem modelItem) {
        Vector vector = null;
        ModelChangeSupport modelChangeSupport = this;
        synchronized (modelChangeSupport) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ModelListener modelListener = (ModelListener)vector.elementAt(i);
                modelListener.itemAdded(modelItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireItemsRemoved(ModelItem[] modelItemArray) {
        Vector vector = null;
        ModelChangeSupport modelChangeSupport = this;
        synchronized (modelChangeSupport) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ModelListener modelListener = (ModelListener)vector.elementAt(i);
                modelListener.itemsRemoved(modelItemArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireModelCleared() {
        Vector vector = null;
        ModelChangeSupport modelChangeSupport = this;
        synchronized (modelChangeSupport) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ModelListener modelListener = (ModelListener)vector.elementAt(i);
                modelListener.modelCleared();
            }
        }
    }

    public synchronized void addModelListener(ModelListener modelListener) {
        if (modelListener instanceof ModelListenerProxy) {
            ModelListenerProxy modelListenerProxy = (ModelListenerProxy)modelListener;
            this.addModelListener(modelListenerProxy.getFieldID(), (ModelListener)modelListenerProxy.getListener());
        } else {
            if (this.listeners == null) {
                this.listeners = new Vector();
            }
            this.listeners.addElement(modelListener);
        }
    }

    public synchronized void addModelListener(int n, ModelListener modelListener) {
        Integer n2;
        ModelChangeSupport modelChangeSupport;
        if (this.children == null) {
            this.children = new Hashtable();
        }
        if ((modelChangeSupport = (ModelChangeSupport)this.children.get(n2 = new Integer(n))) == null) {
            modelChangeSupport = new ModelChangeSupport(this.source);
            this.children.put(n2, modelChangeSupport);
        }
        modelChangeSupport.addModelListener(modelListener);
    }
}

