/*
 * Decompiled with CFR 0.152.
 */
package frost.util.model;

import frost.util.model.ModelChangeSupport;
import frost.util.model.ModelItem;
import frost.util.model.ModelListener;

public abstract class Model {
    private ModelChangeSupport changeSupport;

    void itemChanged(ModelItem modelItem, int n, Object object, Object object2) {
        this.fireItemChanged(modelItem, n, object, object2);
    }

    void itemChanged(ModelItem modelItem) {
        this.fireItemChanged(modelItem);
    }

    protected void fireItemAdded(ModelItem modelItem) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.fireItemAdded(modelItem);
    }

    protected void fireModelCleared() {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.fireModelCleared();
    }

    protected void fireItemsRemoved(ModelItem[] modelItemArray) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.fireItemsRemoved(modelItemArray);
    }

    protected void fireItemChanged(ModelItem modelItem) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.fireItemChanged(modelItem);
    }

    protected void fireItemChanged(ModelItem modelItem, int n, Object object, Object object2) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.fireItemChanged(modelItem, n, object, object2);
    }

    public synchronized void addModelListener(ModelListener modelListener) {
        if (modelListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new ModelChangeSupport(this);
        }
        this.changeSupport.addModelListener(modelListener);
    }

    public synchronized void addModelListener(int n, ModelListener modelListener) {
        if (modelListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new ModelChangeSupport(this);
        }
        this.changeSupport.addModelListener(n, modelListener);
    }

    protected abstract void addItem(ModelItem var1);

    public abstract boolean removeItems(ModelItem[] var1);

    public abstract int getItemCount();

    public abstract void clear();
}

