/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.translation;

import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;

public class Language {
    private static Logger logger = Logger.getLogger(Language.class.getName());
    private ResourceBundle resourceBundle;
    private static boolean initialized = false;
    private static Language instance = null;
    protected EventListenerList listenerList = new EventListenerList();

    private Language(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public static Language getInstance() {
        return instance;
    }

    public static void initialize(ResourceBundle resourceBundle) {
        if (!initialized) {
            initialized = true;
            instance = new Language(resourceBundle);
        }
    }

    public static void initialize(String string) {
        Language.initialize(string, Locale.getDefault());
    }

    public static void initialize(String string, Locale locale) {
        Language.initialize(ResourceBundle.getBundle(string, locale));
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void addLanguageListener(LanguageListener languageListener) {
        this.listenerList.add(LanguageListener.class, languageListener);
    }

    public LanguageListener[] getActionListeners() {
        return (LanguageListener[])this.listenerList.getListeners(LanguageListener.class);
    }

    public void removeLanguageListener(LanguageListener languageListener) {
        this.listenerList.remove(LanguageListener.class, languageListener);
    }

    protected void fireLanguageChanged(LanguageEvent languageEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        LanguageEvent languageEvent2 = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != LanguageListener.class) continue;
            if (languageEvent2 == null) {
                languageEvent2 = new LanguageEvent(this);
            }
            ((LanguageListener)objectArray[i + 1]).languageChanged(languageEvent2);
        }
    }

    public void setLanguageResource(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
        this.fireLanguageChanged(new LanguageEvent(this));
    }

    public String getString(String string) {
        String string2;
        try {
            string2 = this.resourceBundle.getString(string);
        }
        catch (Throwable throwable) {
            string2 = null;
            logger.log(Level.SEVERE, "Exception catched", throwable);
        }
        if (string2 == null) {
            logger.severe("No translation found for key '" + string + "', using key.");
            return string;
        }
        return string2;
    }
}

