/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.translation;

import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import javax.swing.JComboBox;

public class JTranslatableComboBox
extends JComboBox
implements LanguageListener {
    private Language language = null;
    private String[] keys;

    public JTranslatableComboBox(Language language, String[] stringArray) {
        this.language = language;
        this.keys = stringArray;
        language.addLanguageListener(this);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = language.getString(stringArray[i]);
            CheckBoxItem checkBoxItem = new CheckBoxItem(stringArray[i], string);
            this.addItem(checkBoxItem);
        }
    }

    public void languageChanged(LanguageEvent languageEvent) {
        this.refreshLanguage();
    }

    private void refreshLanguage() {
        for (int i = 0; i < this.keys.length; ++i) {
            CheckBoxItem checkBoxItem = (CheckBoxItem)this.getItemAt(i);
            String string = this.language.getString(checkBoxItem.getKey());
            checkBoxItem.setValue(string);
        }
        CheckBoxItem checkBoxItem = new CheckBoxItem("", "");
        this.addItem(checkBoxItem);
        this.removeItem(checkBoxItem);
    }

    public String getSelectedKey() {
        Object object = this.getSelectedItem();
        if (object != null && object instanceof CheckBoxItem) {
            return ((CheckBoxItem)object).getKey();
        }
        return null;
    }

    public void setSelectedKey(String string) {
        boolean bl = false;
        for (int i = 0; i < this.getItemCount() && !bl; ++i) {
            Object e = this.getItemAt(i);
            if (!(e instanceof CheckBoxItem) || !((CheckBoxItem)e).getKey().equals(string)) continue;
            this.setSelectedIndex(i);
            bl = true;
        }
    }

    private class CheckBoxItem {
        private String key = null;
        private String value = null;

        public CheckBoxItem(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        public String getKey() {
            return this.key;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String toString() {
            return this.value;
        }
    }
}

