/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.translation.Language;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class TextComponentClipboardMenu
extends MouseAdapter
implements ClipboardOwner,
ActionListener {
    private static Logger logger = Logger.getLogger(TextComponentClipboardMenu.class.getName());
    private Language language;
    private JTextComponent textComponent;
    private Clipboard clipboard;
    private JPopupMenu popupMenu;
    private JMenuItem cutItem;
    private JMenuItem copyItem;
    private JMenuItem pasteItem;
    private JMenuItem cancelItem;

    public TextComponentClipboardMenu(JTextComponent jTextComponent, Language language) {
        this.textComponent = jTextComponent;
        this.language = language;
        jTextComponent.addMouseListener(this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.textComponent.isEnabled()) {
            this.showPopup(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.textComponent.isEnabled()) {
            this.showPopup(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cutItem) {
            this.cutSelectedText();
        }
        if (actionEvent.getSource() == this.copyItem) {
            this.copySelectedText();
        }
        if (actionEvent.getSource() == this.pasteItem) {
            this.pasteText();
        }
    }

    private void showPopup(int n, int n2) {
        this.createPopupMenu();
        this.cutItem.setText(this.language.getString("Cut"));
        this.copyItem.setText(this.language.getString("Copy"));
        this.pasteItem.setText(this.language.getString("Paste"));
        this.cancelItem.setText(this.language.getString("Cancel"));
        if (this.textComponent.getSelectedText() != null) {
            if (this.textComponent.isEditable()) {
                this.cutItem.setEnabled(true);
            } else {
                this.cutItem.setEnabled(false);
            }
            this.copyItem.setEnabled(true);
        } else {
            this.cutItem.setEnabled(false);
            this.copyItem.setEnabled(false);
        }
        Transferable transferable = this.getClipboard().getContents(this);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            if (this.textComponent.isEditable()) {
                this.pasteItem.setEnabled(true);
            } else {
                this.pasteItem.setEnabled(false);
            }
        } else {
            this.pasteItem.setEnabled(false);
        }
        this.popupMenu.show(this.textComponent, n, n2);
    }

    private void pasteText() {
        Transferable transferable = this.clipboard.getContents(this);
        try {
            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            Caret caret = this.textComponent.getCaret();
            int n = Math.min(caret.getDot(), caret.getMark());
            int n2 = Math.max(caret.getDot(), caret.getMark());
            Document document = this.textComponent.getDocument();
            if (document instanceof PlainDocument) {
                ((PlainDocument)document).replace(n, n2 - n, string, null);
            } else {
                if (n != n2) {
                    document.remove(n, n2 - n);
                }
                document.insertString(n, string, null);
            }
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Problem while pasting text.", iOException);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            logger.log(Level.SEVERE, "Problem while pasting text.", unsupportedFlavorException);
        }
        catch (BadLocationException badLocationException) {
            logger.log(Level.SEVERE, "Problem while pasting text.", badLocationException);
        }
    }

    private void createPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.cutItem = new JMenuItem();
            this.copyItem = new JMenuItem();
            this.pasteItem = new JMenuItem();
            this.cancelItem = new JMenuItem();
            this.cutItem.addActionListener(this);
            this.copyItem.addActionListener(this);
            this.pasteItem.addActionListener(this);
            this.popupMenu.add(this.cutItem);
            this.popupMenu.add(this.copyItem);
            this.popupMenu.add(this.pasteItem);
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.cancelItem);
        }
    }

    private Clipboard getClipboard() {
        if (this.clipboard == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.clipboard = toolkit.getSystemClipboard();
        }
        return this.clipboard;
    }

    private void copySelectedText() {
        StringSelection stringSelection = new StringSelection(this.textComponent.getSelectedText());
        this.clipboard.setContents(stringSelection, this);
    }

    private void cutSelectedText() {
        StringSelection stringSelection = new StringSelection(this.textComponent.getSelectedText());
        this.clipboard.setContents(stringSelection, this);
        int n = this.textComponent.getSelectionStart();
        int n2 = this.textComponent.getSelectionEnd();
        try {
            this.textComponent.getDocument().remove(n, n2 - n);
        }
        catch (BadLocationException badLocationException) {
            logger.log(Level.SEVERE, "Problem while cutting text.", badLocationException);
        }
    }
}

