/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.GlassPane;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public abstract class SwingWorker {
    private Thread thread;
    private static Logger logger = Logger.getLogger(SwingWorker.class.getName());
    private ThreadVar threadVar;
    private GlassPane glassPane;
    private Component aComponent;

    public SwingWorker(Component component) {
        this.setAComponent(component);
        final Runnable runnable = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingWorker.this.construct();
                }
                finally {
                    SwingWorker.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(runnable);
            }
        };
        Thread thread = new Thread(Thread.currentThread().getThreadGroup(), runnable2);
        this.threadVar = new ThreadVar(thread);
    }

    private void activateGlassPane() {
        GlassPane glassPane = GlassPane.mount(this.getAComponent(), true);
        this.setGlassPane(glassPane);
        if (this.getGlassPane() != null) {
            this.getGlassPane().setVisible(true);
        }
    }

    private void construct() {
        this.activateGlassPane();
        try {
            this.doNonUILogic();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void deactivateGlassPane() {
        if (this.getGlassPane() != null) {
            this.getGlassPane().setVisible(false);
        }
    }

    protected abstract void doNonUILogic() throws RuntimeException;

    protected abstract void doUIUpdateLogic() throws RuntimeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finished() {
        try {
            this.deactivateGlassPane();
            this.doUIUpdateLogic();
        }
        catch (RuntimeException runtimeException) {
            logger.log(Level.SEVERE, "SwingWorker error", runtimeException);
        }
        finally {
            if (this.getAComponent() != null) {
                this.getAComponent().requestFocus();
            }
        }
    }

    protected Component getAComponent() {
        return this.aComponent;
    }

    protected GlassPane getGlassPane() {
        return this.glassPane;
    }

    public void interrupt() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.interrupt();
        }
        this.threadVar.clear();
    }

    protected void setAComponent(Component component) {
        this.aComponent = component;
    }

    protected void setGlassPane(GlassPane glassPane) {
        this.glassPane = glassPane;
    }

    public void start() {
        Thread thread = this.threadVar.get();
        if (thread != null) {
            thread.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread thread) {
            this.thread = thread;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

