/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import frost.util.gui.JSkinnablePopupMenu;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SkinChooser
extends JPanel {
    private static Logger logger = Logger.getLogger(SkinChooser.class.getName());
    private static final String THEMES_DIR = "themes";
    EventHandler eventHandler = new EventHandler();
    private JPanel buttonsPanel = null;
    private JButton previewButton = null;
    private JButton refreshButton = null;
    private JPanel labelPanel = null;
    private JLabel availableSkinsLabel = null;
    private JScrollPane listScrollPane = null;
    private JList skinsList = null;
    private JCheckBox enableSkinsCheckBox = null;
    private ResourceBundle languageBundle = null;
    private boolean noSkinsFound = true;
    private LookAndFeel initialLookAndFeel = null;
    private Skin initialSkin = null;
    private boolean skinsEnabled = false;
    private String selectedSkin = null;

    public SkinChooser(ResourceBundle resourceBundle) {
        this.languageBundle = resourceBundle;
        this.initialize();
    }

    private void initialize() {
        this.setName("SkinChooser");
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(10);
        borderLayout.setHgap(0);
        this.setLayout(borderLayout);
        this.add((Component)this.getEnableSkinsCheckBox(), "North");
        this.add((Component)this.getListScrollPane(), "Center");
        this.add((Component)this.getButtonsPanel(), "South");
        this.add((Component)this.getLabelPanel(), "West");
        this.initConnections();
        this.storeLookAndFeelState();
        this.refreshSkinsList();
    }

    private JCheckBox getEnableSkinsCheckBox() {
        if (this.enableSkinsCheckBox == null) {
            this.enableSkinsCheckBox = new JCheckBox();
            this.enableSkinsCheckBox.setName("EnableSkinsCheckBox");
            this.enableSkinsCheckBox.setText(this.languageBundle.getString("EnableSkins"));
            this.enableSkinsCheckBox.setMargin(new Insets(2, 2, 2, 2));
            this.enableSkinsCheckBox.setSelected(true);
        }
        return this.enableSkinsCheckBox;
    }

    private void storeLookAndFeelState() {
        this.initialLookAndFeel = UIManager.getLookAndFeel();
        if (this.initialLookAndFeel instanceof SkinLookAndFeel) {
            this.initialSkin = SkinLookAndFeel.getSkin();
        }
    }

    private JList getSkinsList() {
        if (this.skinsList == null) {
            this.skinsList = new JList();
            this.skinsList.setName("SkinsList");
            this.skinsList.setSelectionMode(0);
        }
        return this.skinsList;
    }

    public String getSelectedSkin() {
        return this.selectedSkin;
    }

    public void setSelectedSkin(String string) {
        this.getSkinsList().setSelectedValue(string, true);
        if (!this.getSkinsList().isSelectionEmpty() && string.equals("none")) {
            this.selectedSkin = string;
            if (this.skinsEnabled) {
                this.getPreviewButton().setEnabled(true);
            }
        }
    }

    private void initConnections() {
        this.getEnableSkinsCheckBox().addActionListener(this.eventHandler);
        this.getPreviewButton().addActionListener(this.eventHandler);
        this.getRefreshButton().addActionListener(this.eventHandler);
        this.getSkinsList().addListSelectionListener(this.eventHandler);
    }

    protected void previewButtonPressed(ActionEvent actionEvent) {
        this.commitChanges();
    }

    protected void refreshButtonPressed(ActionEvent actionEvent) {
        this.refreshSkinsList();
        this.selectedSkin = null;
        this.getPreviewButton().setEnabled(false);
    }

    protected void enableSkinsPressed(ActionEvent actionEvent) {
        this.setSkinsEnabled(this.getEnableSkinsCheckBox().isSelected());
    }

    public void commitChanges() {
        if (this.selectedSkin != null && this.skinsEnabled) {
            try {
                Skin skin = SkinLookAndFeel.loadThemePack(this.selectedSkin);
                SkinLookAndFeel.setSkin(skin);
                UIManager.setLookAndFeel(new SkinLookAndFeel());
                this.updateComponentTreesUI();
            }
            catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                logger.log(Level.SEVERE, "The selected skin is not supported by your system", unsupportedLookAndFeelException);
                this.setSelectedSkin("none");
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "There was an error while loading the selected skin", exception);
                this.setSelectedSkin("none");
            }
        } else {
            String string = UIManager.getSystemLookAndFeelClassName();
            try {
                UIManager.setLookAndFeel(string);
                this.updateComponentTreesUI();
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "There was an error while setting the system look and feel", exception);
            }
        }
    }

    private void refreshSkinsList() {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            this.buildSkinsList(linkedList, new File(THEMES_DIR));
            Collections.sort(linkedList);
            if (linkedList.isEmpty()) {
                linkedList.add(this.languageBundle.getString("NoSkinsFound"));
                this.noSkinsFound = true;
                this.getSkinsList().setEnabled(false);
                this.getSkinsList().setEnabled(false);
            } else {
                this.noSkinsFound = false;
                if (this.isEnabled()) {
                    this.getSkinsList().setEnabled(true);
                }
            }
            this.getSkinsList().setListData(linkedList.toArray());
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "Exception thrown in refreshSkinsList()", iOException);
        }
    }

    private void buildSkinsList(Collection collection, File file) throws IOException {
        if (!file.isDirectory() || !file.exists()) {
            return;
        }
        String[] stringArray = file.list();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                this.buildSkinsList(collection, file2);
                continue;
            }
            if (!this.accept(file2)) continue;
            try {
                collection.add(file2.getCanonicalPath());
                continue;
            }
            catch (IOException iOException) {
                throw new IOException("Exception while building the skins list: \n" + iOException.getMessage());
            }
        }
    }

    private boolean accept(File file) {
        return !file.isDirectory() && file.getName().endsWith(".zip");
    }

    protected void skinSelected(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting()) {
            if (this.getSkinsList().getSelectedIndex() == -1) {
                this.selectedSkin = null;
                this.getPreviewButton().setEnabled(false);
            } else {
                this.selectedSkin = this.getSkinsList().getSelectedValue().toString();
                if (this.skinsEnabled) {
                    this.getPreviewButton().setEnabled(true);
                }
            }
        }
    }

    private JScrollPane getListScrollPane() {
        if (this.listScrollPane == null) {
            this.listScrollPane = new JScrollPane();
            this.listScrollPane.setName("ListScrollPane");
            this.listScrollPane.setVerticalScrollBarPolicy(20);
            this.listScrollPane.setHorizontalScrollBarPolicy(30);
            this.listScrollPane.setViewportView(this.getSkinsList());
        }
        return this.listScrollPane;
    }

    private JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setName("ButtonsPanel");
            this.buttonsPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.ipadx = 20;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.getButtonsPanel().add((Component)this.getPreviewButton(), gridBagConstraints);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.ipadx = 20;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 0);
            this.getButtonsPanel().add((Component)this.getRefreshButton(), gridBagConstraints2);
        }
        return this.buttonsPanel;
    }

    private JPanel getLabelPanel() {
        if (this.labelPanel == null) {
            this.labelPanel = new JPanel();
            this.labelPanel.setName("LabelPanel");
            this.labelPanel.setLayout(new BorderLayout());
            this.labelPanel.add((Component)this.getAvailableSkinsLabel(), "North");
        }
        return this.labelPanel;
    }

    private JLabel getAvailableSkinsLabel() {
        if (this.availableSkinsLabel == null) {
            this.availableSkinsLabel = new JLabel();
            this.availableSkinsLabel.setName("AvailableSkinsLabel");
            this.availableSkinsLabel.setText(this.languageBundle.getString("AvailableSkins"));
            this.availableSkinsLabel.setMaximumSize(new Dimension(200, 30));
            this.availableSkinsLabel.setHorizontalTextPosition(0);
            this.availableSkinsLabel.setPreferredSize(new Dimension(120, 30));
            this.availableSkinsLabel.setMinimumSize(new Dimension(90, 30));
            this.availableSkinsLabel.setHorizontalAlignment(0);
        }
        return this.availableSkinsLabel;
    }

    private JButton getPreviewButton() {
        if (this.previewButton == null) {
            this.previewButton = new JButton();
            this.previewButton.setName("PreviewButton");
            this.previewButton.setText(this.languageBundle.getString("Preview"));
            this.previewButton.setEnabled(false);
        }
        return this.previewButton;
    }

    private JButton getRefreshButton() {
        if (this.refreshButton == null) {
            this.refreshButton = new JButton();
            this.refreshButton.setName("RefreshButton");
            this.refreshButton.setText(this.languageBundle.getString("RefreshList"));
        }
        return this.refreshButton;
    }

    public void cancelChanges() {
        try {
            UIManager.setLookAndFeel(this.initialLookAndFeel);
            if (this.initialLookAndFeel instanceof SkinLookAndFeel) {
                SkinLookAndFeel.setSkin(this.initialSkin);
            }
            this.updateComponentTreesUI();
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            logger.log(Level.SEVERE, "There was an exception when restoring the state of the Look and Feel", unsupportedLookAndFeelException);
        }
    }

    private void updateComponentTreesUI() {
        int n;
        Frame[] frameArray = Frame.getFrames();
        JSkinnablePopupMenu[] jSkinnablePopupMenuArray = JSkinnablePopupMenu.getSkinnablePopupMenus();
        for (n = 0; n < frameArray.length; ++n) {
            SwingUtilities.updateComponentTreeUI(frameArray[n]);
            Window[] windowArray = frameArray[n].getOwnedWindows();
            for (int i = 0; i < windowArray.length; ++i) {
                if (!(windowArray[i] instanceof Dialog)) continue;
                SwingUtilities.updateComponentTreeUI(windowArray[i]);
            }
        }
        for (n = 0; n < jSkinnablePopupMenuArray.length; ++n) {
            SwingUtilities.updateComponentTreeUI(jSkinnablePopupMenuArray[n]);
        }
    }

    public void setSkinsEnabled(boolean bl) {
        this.skinsEnabled = bl;
        if (bl && this.selectedSkin != null) {
            this.getPreviewButton().setEnabled(true);
        } else {
            this.getPreviewButton().setEnabled(false);
        }
        this.getEnableSkinsCheckBox().setSelected(bl);
        this.getRefreshButton().setEnabled(bl);
        this.getSkinsList().setEnabled(bl);
    }

    public boolean isSkinsEnabled() {
        return this.skinsEnabled;
    }

    public class EventHandler
    implements ActionListener,
    ListSelectionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == SkinChooser.this.getPreviewButton()) {
                SkinChooser.this.previewButtonPressed(actionEvent);
            }
            if (actionEvent.getSource() == SkinChooser.this.getRefreshButton()) {
                SkinChooser.this.refreshButtonPressed(actionEvent);
            }
            if (actionEvent.getSource() == SkinChooser.this.getEnableSkinsCheckBox()) {
                SkinChooser.this.enableSkinsPressed(actionEvent);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == SkinChooser.this.getSkinsList()) {
                SkinChooser.this.skinSelected(listSelectionEvent);
            }
        }
    }
}

