/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.translation.Language;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class MiscToolkit {
    private static MiscToolkit instance = new MiscToolkit();
    private static Logger logger = Logger.getLogger(MiscToolkit.class.getName());

    public static MiscToolkit getInstance() {
        return instance;
    }

    private MiscToolkit() {
    }

    public void configureButton(JButton jButton, String string) {
        jButton.setRolloverIcon(new ImageIcon(this.getClass().getResource(string)));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setBorderPainted(false);
        jButton.setFocusPainted(false);
    }

    public void configureButton(JButton jButton, String string, String string2, ResourceBundle resourceBundle) {
        String string3 = null;
        try {
            string3 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            logger.severe("Missing resource in configureButton method: " + string);
            string3 = string;
        }
        jButton.setToolTipText(string3);
        this.configureButton(jButton, string2);
    }

    public void configureButton(JButton jButton, String string, String string2, Language language) {
        this.configureButton(jButton, string, string2, language.getResourceBundle());
    }

    public ImageIcon getScaledImage(String string, int n, int n2) {
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource(string));
        imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(n, n2, 4));
        return imageIcon;
    }

    public void setContainerEnabled(Container container, boolean bl) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                this.setContainerEnabledInner((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    public void setContainerEnabled(Container container, boolean bl, Collection collection) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (collection.contains(component)) continue;
            if (component instanceof Container) {
                this.setContainerEnabledInner((Container)component, bl, collection);
                continue;
            }
            component.setEnabled(bl);
        }
    }

    private void setContainerEnabledInner(Container container, boolean bl) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                this.setContainerEnabledInner((Container)component, bl);
                continue;
            }
            component.setEnabled(bl);
        }
        container.setEnabled(bl);
    }

    private void setContainerEnabledInner(Container container, boolean bl, Collection collection) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (collection.contains(component)) continue;
            if (component instanceof Container) {
                this.setContainerEnabledInner((Container)component, bl, collection);
                continue;
            }
            component.setEnabled(bl);
        }
        container.setEnabled(bl);
    }

    public void showMessage(String string, int n, String string2) {
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Frost");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2, dimension.height / 2);
        jFrame.setUndecorated(true);
        jFrame.setVisible(true);
        jFrame.toFront();
        JOptionPane.showMessageDialog(jFrame, string, string2, n);
        jFrame.dispose();
    }

    public String showInputDialog(Object object) {
        JFrame jFrame = new JFrame();
        jFrame.setTitle("Frost");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        jFrame.setLocation(dimension.width / 2, dimension.height / 2);
        jFrame.setUndecorated(true);
        jFrame.setVisible(true);
        jFrame.toFront();
        String string = JOptionPane.showInputDialog(jFrame, object);
        jFrame.dispose();
        return string;
    }
}

