/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JDragTree
extends JTree
implements DragGestureListener,
DragSourceListener {
    private static Logger logger = Logger.getLogger(JDragTree.class.getName());
    private TreePath _pathSource;
    private BufferedImage _imgGhost;
    private Point _ptOffset = new Point();
    public static final DataFlavor TREEPATH_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "TreePath");
    private DataFlavor[] _flavors = new DataFlavor[]{TREEPATH_FLAVOR};
    private DragSource dragSource = null;
    private DragGestureRecognizer dgRecognizer = null;
    private DropTarget dropTarget = null;

    public JDragTree(TreeNode treeNode) {
        super(treeNode);
        this.initialize();
    }

    public JDragTree(TreeModel treeModel) {
        super(treeModel);
        this.initialize();
    }

    private void initialize() {
        this.dragSource = DragSource.getDefaultDragSource();
        this.dgRecognizer = this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.dgRecognizer.setSourceActions(this.dgRecognizer.getSourceActions() & 0xFFFFFFFB & 0xFFFFFFF7);
        this.dropTarget = new DropTarget(this, new CDropTargetListener());
    }

    private boolean isRootPath(TreePath treePath) {
        return this.isRootVisible() && this.getRowForPath(treePath) == 0;
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.repaint();
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        InputEvent inputEvent = dragGestureEvent.getTriggerEvent();
        if (inputEvent instanceof MouseEvent && (((MouseEvent)inputEvent).getModifiers() & 4) != 0) {
            return;
        }
        Point point = dragGestureEvent.getDragOrigin();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return;
        }
        if (this.isRootPath(treePath)) {
            return;
        }
        Rectangle rectangle = this.getPathBounds(treePath);
        this._ptOffset.setLocation(point.x - rectangle.x, point.y - rectangle.y);
        JLabel jLabel = (JLabel)this.getCellRenderer().getTreeCellRendererComponent(this, treePath.getLastPathComponent(), false, this.isExpanded(treePath), this.getModel().isLeaf(treePath.getLastPathComponent()), 0, false);
        jLabel.setSize((int)rectangle.getWidth(), (int)rectangle.getHeight());
        this._imgGhost = new BufferedImage((int)rectangle.getWidth(), (int)rectangle.getHeight(), 3);
        Graphics2D graphics2D = this._imgGhost.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(2, 0.5f));
        jLabel.paint(graphics2D);
        Icon icon = jLabel.getIcon();
        int n = icon == null ? 0 : icon.getIconWidth() + jLabel.getIconTextGap();
        graphics2D.setComposite(AlphaComposite.getInstance(4, 0.5f));
        graphics2D.setPaint(new GradientPaint(n, 0.0f, SystemColor.controlShadow, this.getWidth(), 0.0f, new Color(255, 255, 255, 0)));
        graphics2D.fillRect(n, 0, this.getWidth(), this._imgGhost.getHeight());
        graphics2D.dispose();
        this.setSelectionPath(treePath);
        CTransferableTreePath cTransferableTreePath = new CTransferableTreePath(treePath);
        this._pathSource = treePath;
        dragGestureEvent.startDrag(null, this._imgGhost, new Point(5, 5), cTransferableTreePath, this);
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    private class CTransferableTreePath
    implements Transferable {
        private TreePath _path;

        public CTransferableTreePath(TreePath treePath) {
            this._path = treePath;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return JDragTree.this._flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return Arrays.asList(JDragTree.this._flavors).contains(dataFlavor);
        }

        public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
            if (dataFlavor.isMimeTypeEqual(TREEPATH_FLAVOR.getMimeType())) {
                return this._path;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    private class CDropTargetListener
    implements DropTargetListener {
        private TreePath _pathLast = null;
        private Rectangle2D _raCueLine = new Rectangle2D.Float();
        private Rectangle2D _raGhost = new Rectangle2D.Float();
        private Color _colorCueLine;
        private Point _ptLast = new Point();
        private Timer _timerHover;
        private int _nLeftRight = 0;
        private int _nShift = 0;

        public CDropTargetListener() {
            this._colorCueLine = new Color(SystemColor.controlShadow.getRed(), SystemColor.controlShadow.getGreen(), SystemColor.controlShadow.getBlue(), 64);
            this._timerHover = new Timer(1000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CDropTargetListener.this._nLeftRight = 0;
                    if (JDragTree.this.isRootPath(CDropTargetListener.this._pathLast)) {
                        return;
                    }
                    if (JDragTree.this.isExpanded(CDropTargetListener.this._pathLast)) {
                        JDragTree.this.collapsePath(CDropTargetListener.this._pathLast);
                    } else {
                        JDragTree.this.expandPath(CDropTargetListener.this._pathLast);
                    }
                }
            });
            this._timerHover.setRepeats(false);
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            if (!this.isDragAcceptable(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            if (!DragSource.isDragImageSupported()) {
                JDragTree.this.repaint(this._raGhost.getBounds());
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            if (dropTargetDragEvent == null || this._raGhost == null || this._ptLast == null || JDragTree.this._ptOffset == null || JDragTree.this._imgGhost == null || this._raCueLine == null) {
                return;
            }
            Point point = dropTargetDragEvent.getLocation();
            if (point == null) {
                return;
            }
            if (point.equals(this._ptLast)) {
                return;
            }
            int n = point.x - this._ptLast.x;
            if (this._nLeftRight > 0 && n < 0 || this._nLeftRight < 0 && n > 0) {
                this._nLeftRight = 0;
            }
            this._nLeftRight += n;
            this._ptLast = point;
            Graphics2D graphics2D = (Graphics2D)JDragTree.this.getGraphics();
            if (graphics2D == null) {
                return;
            }
            if (!DragSource.isDragImageSupported()) {
                JDragTree.this.paintImmediately(this._raGhost.getBounds());
                this._raGhost.setRect(point.x - ((JDragTree)JDragTree.this)._ptOffset.x, point.y - ((JDragTree)JDragTree.this)._ptOffset.y, JDragTree.this._imgGhost.getWidth(), JDragTree.this._imgGhost.getHeight());
                graphics2D.drawImage(JDragTree.this._imgGhost, AffineTransform.getTranslateInstance(this._raGhost.getX(), this._raGhost.getY()), null);
            } else {
                JDragTree.this.paintImmediately(this._raCueLine.getBounds());
            }
            TreePath treePath = JDragTree.this.getClosestPathForLocation(point.x, point.y);
            if (treePath != this._pathLast) {
                this._nLeftRight = 0;
                this._pathLast = treePath;
                this._timerHover.restart();
            }
            Rectangle rectangle = JDragTree.this.getPathBounds(treePath);
            this._raCueLine.setRect(0.0, rectangle.y + (int)rectangle.getHeight(), JDragTree.this.getWidth(), 2.0);
            graphics2D.setColor(this._colorCueLine);
            graphics2D.fill(this._raCueLine);
            this._nShift = 0;
            this._raGhost = this._raGhost.createUnion(this._raCueLine);
            if (treePath.equals(JDragTree.this._pathSource)) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (!this.isDragAcceptable(dropTargetDragEvent)) {
                dropTargetDragEvent.rejectDrag();
            } else {
                dropTargetDragEvent.acceptDrag(dropTargetDragEvent.getDropAction());
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            this._timerHover.stop();
            if (!this.isDropAcceptable(dropTargetDropEvent)) {
                dropTargetDropEvent.rejectDrop();
                return;
            }
            dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
            Transferable transferable = dropTargetDropEvent.getTransferable();
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                DataFlavor dataFlavor = dataFlavorArray[i];
                if (!dataFlavor.isMimeTypeEqual("application/x-java-jvm-local-objectref")) continue;
                try {
                    Point point = dropTargetDropEvent.getLocation();
                    TreePath treePath = JDragTree.this.getClosestPathForLocation(point.x, point.y);
                    TreePath treePath2 = (TreePath)transferable.getTransferData(dataFlavor);
                    if (treePath == null || treePath2 == null) {
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath2.getLastPathComponent();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                    DefaultMutableTreeNode defaultMutableTreeNode4 = (DefaultMutableTreeNode)defaultMutableTreeNode3.getParent();
                    if (!defaultMutableTreeNode.isLeaf() && defaultMutableTreeNode3.getParent() == defaultMutableTreeNode) {
                        dropTargetDropEvent.dropComplete(false);
                        return;
                    }
                    DefaultTreeModel defaultTreeModel = (DefaultTreeModel)JDragTree.this.getModel();
                    TreePath treePath3 = null;
                    if (defaultMutableTreeNode3.isLeaf() || JDragTree.this.isCollapsed(treePath)) {
                        int n = defaultMutableTreeNode4.getIndex(defaultMutableTreeNode3);
                        if (n < 0) {
                            logger.warning("child not found in parent!!!");
                            dropTargetDropEvent.dropComplete(false);
                            return;
                        }
                        Object[] objectArray = new Object[]{defaultMutableTreeNode};
                        int[] nArray = new int[]{defaultMutableTreeNode2.getIndex(defaultMutableTreeNode)};
                        defaultMutableTreeNode.removeFromParent();
                        defaultTreeModel.nodesWereRemoved(defaultMutableTreeNode2, nArray, objectArray);
                        if (++n >= defaultMutableTreeNode4.getChildCount()) {
                            defaultMutableTreeNode4.add(defaultMutableTreeNode);
                            int[] nArray2 = new int[]{defaultMutableTreeNode4.getChildCount() - 1};
                            defaultTreeModel.nodesWereInserted(defaultMutableTreeNode4, nArray2);
                        } else {
                            defaultMutableTreeNode4.insert(defaultMutableTreeNode, n);
                            int[] nArray3 = new int[]{n};
                            defaultTreeModel.nodesWereInserted(defaultMutableTreeNode4, nArray3);
                        }
                    } else {
                        Object[] objectArray = new Object[]{defaultMutableTreeNode};
                        int[] nArray = new int[]{defaultMutableTreeNode2.getIndex(defaultMutableTreeNode)};
                        defaultMutableTreeNode.removeFromParent();
                        defaultTreeModel.nodesWereRemoved(defaultMutableTreeNode2, nArray, objectArray);
                        defaultMutableTreeNode3.insert(defaultMutableTreeNode, 0);
                        int[] nArray4 = new int[]{0};
                        defaultTreeModel.nodesWereInserted(defaultMutableTreeNode3, nArray4);
                    }
                    if (treePath3 == null) break;
                    JDragTree.this.setSelectionPath(treePath3);
                    break;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    logger.log(Level.SEVERE, "Exception thrown in drop(DropTargetDropEvent e)", unsupportedFlavorException);
                    dropTargetDropEvent.dropComplete(false);
                    return;
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, "Exception thrown in drop(DropTargetDropEvent e)", iOException);
                    dropTargetDropEvent.dropComplete(false);
                    return;
                }
            }
            dropTargetDropEvent.dropComplete(true);
        }

        public boolean isDragAcceptable(DropTargetDragEvent dropTargetDragEvent) {
            if ((dropTargetDragEvent.getDropAction() & 2) == 0) {
                return false;
            }
            if (!dropTargetDragEvent.isDataFlavorSupported(TREEPATH_FLAVOR)) {
                return false;
            }
            Point point = dropTargetDragEvent.getLocation();
            TreePath treePath = JDragTree.this.getClosestPathForLocation(point.x, point.y);
            return treePath != null && !treePath.equals(JDragTree.this._pathSource);
        }

        public boolean isDropAcceptable(DropTargetDropEvent dropTargetDropEvent) {
            if ((dropTargetDropEvent.getDropAction() & 2) == 0) {
                return false;
            }
            if (!dropTargetDropEvent.isDataFlavorSupported(TREEPATH_FLAVOR)) {
                return false;
            }
            Point point = dropTargetDropEvent.getLocation();
            TreePath treePath = JDragTree.this.getClosestPathForLocation(point.x, point.y);
            return treePath != null && !treePath.equals(JDragTree.this._pathSource);
        }
    }
}

