/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class JDialogWithDetails
extends JDialog {
    protected Language language = null;
    private boolean moreExtended = false;
    private Listener listener = new Listener();
    private JPanel userPanel = new JPanel();
    private JPanel buttonsPanel = new JPanel();
    private JPanel contentPanel = new JPanel();
    private JPanel morePanel;
    private JButton okButton = new JButton();
    private JButton moreButton = new JButton();
    private JTextArea moreTextArea = new JTextArea();
    private JScrollPane moreScrollPane = new JScrollPane(this.moreTextArea);

    public JDialogWithDetails(Frame frame) {
        this(frame, "");
    }

    public JDialogWithDetails(Frame frame, String string) {
        super(frame);
        this.language = Language.getInstance();
        this.setTitle(string);
        this.initialize();
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    private JPanel getMorePanel() {
        if (this.morePanel == null) {
            this.morePanel = new JPanel(new BorderLayout());
            this.morePanel.setBorder(new EmptyBorder(10, 10, 10, 10));
            new TextComponentClipboardMenu(this.moreTextArea, this.language);
            this.moreTextArea.setEditable(false);
            this.moreTextArea.setColumns(10);
            this.moreTextArea.setMargin(new Insets(0, 3, 0, 3));
            this.moreTextArea.setRows(10);
            this.morePanel.add((Component)this.moreScrollPane, "Center");
        }
        return this.morePanel;
    }

    private void initialize() {
        this.setModal(true);
        this.moreButton.setText(this.language.getString("More") + " >>");
        this.okButton.setText(this.language.getString("OK"));
        this.buttonsPanel.setLayout(new FlowLayout(2, 10, 10));
        this.buttonsPanel.add(this.moreButton);
        this.buttonsPanel.add(this.okButton);
        this.contentPanel.setLayout(new BorderLayout());
        this.contentPanel.add((Component)this.buttonsPanel, "Center");
        this.contentPanel.add((Component)this.userPanel, "North");
        this.getContentPane().add((Component)this.contentPanel, null);
        this.okButton.addActionListener(this.listener);
        this.moreButton.addActionListener(this.listener);
        this.addWindowListener(this.listener);
    }

    private void moreButtonPressed() {
        if (this.moreExtended) {
            this.moreButton.setText(this.language.getString("More") + " >>");
            this.contentPanel.remove(this.getMorePanel());
            this.pack();
            this.moreExtended = false;
        } else {
            this.contentPanel.add((Component)this.getMorePanel(), "South");
            this.moreButton.setText(this.language.getString("Less") + " <<");
            this.pack();
            this.moreExtended = true;
        }
    }

    public void setDetailsText(String string) {
        this.moreTextArea.setText(string);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDialogWithDetails.this.moreScrollPane.getViewport().setViewPosition(new Point(0, 0));
            }
        });
    }

    protected JPanel getButtonsPanel() {
        return this.buttonsPanel;
    }

    public JPanel getUserPanel() {
        return this.userPanel;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }
        super.setVisible(bl);
    }

    public static void showWarningDialog(Frame frame, String string, String string2, String string3) {
        Icon icon = UIManager.getIcon("OptionPane.warningIcon");
        JDialogWithDetails.showDialog(frame, icon, string, string2, string3);
    }

    public static void showErrorDialog(Frame frame, String string, String string2, String string3) {
        Icon icon = UIManager.getIcon("OptionPane.errorIcon");
        JDialogWithDetails.showDialog(frame, icon, string, string2, string3);
    }

    public static void showDialog(Frame frame, Icon icon, String string, String string2, String string3) {
        JDialogWithDetails jDialogWithDetails = new JDialogWithDetails(frame, string);
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 10));
        jLabel.setIcon(icon);
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(10, 10, 10, 20));
        jPanel2.add((Component)new JLabel(string2), "Center");
        jDialogWithDetails.getUserPanel().setLayout(new BorderLayout());
        jDialogWithDetails.getUserPanel().add((Component)jPanel, "West");
        jDialogWithDetails.getUserPanel().add((Component)jPanel2, "Center");
        jDialogWithDetails.setDetailsText(string3);
        jDialogWithDetails.setVisible(true);
    }

    private class Listener
    extends WindowAdapter
    implements ActionListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == JDialogWithDetails.this.moreButton) {
                JDialogWithDetails.this.moreButtonPressed();
            }
            if (actionEvent.getSource() == JDialogWithDetails.this.okButton) {
                JDialogWithDetails.this.close();
            }
        }

        public void windowClosing(WindowEvent windowEvent) {
            JDialogWithDetails.this.close();
            super.windowClosing(windowEvent);
        }
    }
}

