/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class GlassPane
extends JComponent
implements AWTEventListener {
    private Window theWindow;
    private Component activeComponent;
    private static Logger logger = Logger.getLogger(GlassPane.class.getName());

    protected GlassPane(Component component) {
        this.addMouseListener(new MouseAdapter(){});
        this.addKeyListener(new KeyAdapter(){});
        this.setActiveComponent(component);
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        Object object = aWTEvent.getSource();
        boolean bl = aWTEvent.getSource() instanceof Component;
        if (aWTEvent instanceof KeyEvent && bl && SwingUtilities.windowForComponent((Component)object) == this.theWindow) {
            ((KeyEvent)aWTEvent).consume();
        }
    }

    public static synchronized GlassPane mount(Component component, boolean bl) {
        RootPaneContainer rootPaneContainer = null;
        Component component2 = component;
        while (component2.getParent() != null && !(component2 instanceof RootPaneContainer)) {
            component2 = component2.getParent();
        }
        if (component2 instanceof RootPaneContainer) {
            rootPaneContainer = (RootPaneContainer)((Object)component2);
        }
        if (rootPaneContainer != null) {
            if (rootPaneContainer.getGlassPane() != null && rootPaneContainer.getGlassPane() instanceof GlassPane) {
                return (GlassPane)rootPaneContainer.getGlassPane();
            }
            if (bl) {
                GlassPane glassPane = new GlassPane(component);
                rootPaneContainer.setGlassPane(glassPane);
                logger.fine("GlassPane mounted on " + rootPaneContainer.getClass());
                return glassPane;
            }
            return null;
        }
        return null;
    }

    private void setActiveComponent(Component component) {
        this.activeComponent = component;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.theWindow == null) {
                this.theWindow = SwingUtilities.windowForComponent(this.activeComponent);
                if (this.theWindow == null && this.activeComponent instanceof Window) {
                    this.theWindow = (Window)this.activeComponent;
                }
            }
            this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
            this.activeComponent = this.theWindow.getFocusOwner();
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
            this.requestFocus();
            super.setVisible(bl);
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            super.setVisible(bl);
            if (this.getTopLevelAncestor() != null) {
                this.getTopLevelAncestor().setCursor(null);
            }
        }
    }
}

