/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.gui.translation.TranslatableListModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
extends JDialog {
    private Listener listener = new Listener();
    private Language language = null;
    private DefaultListModel fontNamesModel = new DefaultListModel();
    private JList fontNamesList = new JList(this.fontNamesModel);
    private JTextField selectedNameTextField = new JTextField();
    private TranslatableListModel fontStylesModel = null;
    private JList fontStylesList = new JList();
    private JTextField selectedStyleTextField = new JTextField();
    private DefaultListModel fontSizesModel = new DefaultListModel();
    private JList fontSizesList = new JList(this.fontSizesModel);
    private JTextField selectedSizeTextField = new JTextField();
    private JLabel sampleLabel = new JLabel();
    private JTextField sampleTextField = new JTextField();
    private JButton cancelButton = new JButton();
    private JButton okButton = new JButton();
    private Font selectedFont = null;
    private String selectedName = null;
    private Integer selectedSize = null;
    private Integer selectedStyle = null;
    private HashMap styles = new HashMap();

    public FontChooser(Frame frame, Language language) {
        super(frame);
        this.language = language;
        language.addLanguageListener(this.listener);
        this.initialize();
    }

    public FontChooser(Dialog dialog, Language language) {
        super(dialog);
        this.language = language;
        language.addLanguageListener(this.listener);
        this.initialize();
    }

    private void initialize() {
        int n;
        Insets insets;
        this.refreshLanguage();
        this.setSize(400, 350);
        this.setLocationRelativeTo(this.getOwner());
        new TextComponentClipboardMenu(this.selectedNameTextField, this.language);
        new TextComponentClipboardMenu(this.selectedStyleTextField, this.language);
        new TextComponentClipboardMenu(this.selectedSizeTextField, this.language);
        new TextComponentClipboardMenu(this.sampleTextField, this.language);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridBagLayout());
        this.setContentPane(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.fontNamesList.setBorder(new EmptyBorder(1, 1, 1, 4));
        JScrollPane jScrollPane = new JScrollPane(this.fontNamesList);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jScrollPane = new JScrollPane(this.fontStylesList);
        this.fontStylesList.setBorder(new EmptyBorder(1, 1, 1, 4));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jScrollPane = new JScrollPane(this.fontSizesList);
        this.fontSizesList.setBorder(new EmptyBorder(1, 1, 1, 4));
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        this.selectedNameTextField.setEditable(false);
        jPanel.add((Component)this.selectedNameTextField, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.selectedStyleTextField.setEditable(false);
        jPanel.add((Component)this.selectedStyleTextField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.selectedSizeTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.sampleLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        this.sampleTextField.setText("aAbByYzZ");
        jPanel.add((Component)this.sampleTextField, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = insets;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 1.0;
        jPanel2.add((Component)this.okButton, gridBagConstraints2);
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        jPanel2.add((Component)this.cancelButton, gridBagConstraints2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.weighty = 0.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.okButton.addActionListener(this.listener);
        this.cancelButton.addActionListener(this.listener);
        this.fontNamesList.addListSelectionListener(this.listener);
        this.fontStylesList.addListSelectionListener(this.listener);
        this.fontSizesList.addListSelectionListener(this.listener);
        this.selectedSizeTextField.addActionListener(this.listener);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        String[] stringArray2 = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "22", "26", "30", "36", "48", "64"};
        this.styles.put("Plain", new Integer(0));
        this.styles.put("Italic", new Integer(2));
        this.styles.put("Bold", new Integer(1));
        this.styles.put("Bold Italic", new Integer(3));
        for (n = 0; n < stringArray.length; ++n) {
            this.fontNamesModel.addElement(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            this.fontSizesModel.addElement(stringArray2[n]);
        }
        this.fontStylesModel = new TranslatableListModel(this.language);
        this.fontStylesList.setModel(this.fontStylesModel);
        ArrayList arrayList = new ArrayList(this.styles.keySet());
        Collections.reverse(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.fontStylesModel.addElement(iterator.next());
        }
        this.fontNamesList.setSelectedIndex(0);
        this.fontSizesList.setSelectedIndex(0);
        this.fontStylesList.setSelectedIndex(0);
    }

    private void cancelButtonPressed() {
        this.selectedFont = null;
        this.dispose();
    }

    private void okButtonPressed() {
        this.dispose();
    }

    private void fontNameValueChanged() {
        if (this.fontNamesList.getSelectedIndex() != -1) {
            this.selectedName = this.fontNamesList.getSelectedValue().toString();
            this.selectedNameTextField.setText(this.selectedName);
            this.refreshFont();
        }
    }

    private void refreshFont() {
        if (this.selectedName != null && this.selectedSize != null && this.selectedStyle != null) {
            this.selectedFont = new Font(this.selectedName, (int)this.selectedStyle, this.selectedSize);
            this.sampleTextField.setFont(this.selectedFont);
        }
    }

    private void fontStyleValueChanged() {
        int n = this.fontStylesList.getSelectedIndex();
        if (n != -1) {
            String string = this.fontStylesModel.getElementAt(n).toString();
            String string2 = this.fontStylesModel.getKeyAt(n);
            this.selectedStyleTextField.setText(string);
            this.selectedStyle = (Integer)this.styles.get(string2);
            this.refreshFont();
        }
    }

    private void fontSizeValueChanged() {
        if (this.fontSizesList.getSelectedIndex() != -1) {
            this.selectedSize = new Integer(this.fontSizesList.getSelectedValue().toString());
            this.selectedSizeTextField.setText(this.selectedSize.toString());
            this.refreshFont();
        }
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Font font) {
        this.selectedFont = font;
        String string = font.getFamily();
        if (this.fontNamesModel.contains(string)) {
            this.fontNamesList.setSelectedValue(string, true);
        }
        this.selectedSize = new Integer(font.getSize());
        if (this.fontSizesModel.contains(this.selectedSize)) {
            this.fontSizesList.setSelectedValue(this.selectedSize, true);
        } else {
            this.selectedSizeTextField.setText(this.selectedSize.toString());
            this.sizeTyped();
        }
        int n = -1;
        Integer n2 = new Integer(font.getStyle());
        Iterator iterator = this.styles.entrySet().iterator();
        while (iterator.hasNext() && n == -1) {
            Map.Entry entry = iterator.next();
            if (!entry.getValue().equals(n2)) continue;
            n = this.fontStylesModel.indexOfKey(entry.getKey());
        }
        this.fontStylesList.setSelectedIndex(n);
    }

    private void sizeTyped() {
        String string = this.selectedSizeTextField.getText();
        try {
            this.selectedSize = new Integer(string);
            if (this.fontSizesModel.contains(string)) {
                this.fontSizesList.setSelectedValue(string, true);
            } else {
                this.fontSizesList.clearSelection();
            }
            this.refreshFont();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void refreshLanguage() {
        this.setTitle(this.language.getString("Choose a Font"));
        this.sampleLabel.setText(this.language.getString("Sample"));
        this.okButton.setText(this.language.getString("OK"));
        this.cancelButton.setText(this.language.getString("Cancel"));
    }

    private class Listener
    implements ActionListener,
    ListSelectionListener,
    LanguageListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == FontChooser.this.okButton) {
                FontChooser.this.okButtonPressed();
            }
            if (actionEvent.getSource() == FontChooser.this.cancelButton) {
                FontChooser.this.cancelButtonPressed();
            }
            if (actionEvent.getSource() == FontChooser.this.selectedSizeTextField) {
                FontChooser.this.sizeTyped();
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                if (listSelectionEvent.getSource() == FontChooser.this.fontNamesList) {
                    FontChooser.this.fontNameValueChanged();
                }
                if (listSelectionEvent.getSource() == FontChooser.this.fontStylesList) {
                    FontChooser.this.fontStyleValueChanged();
                }
                if (listSelectionEvent.getSource() == FontChooser.this.fontSizesList) {
                    FontChooser.this.fontSizeValueChanged();
                }
            }
        }

        public void languageChanged(LanguageEvent languageEvent) {
            FontChooser.this.refreshLanguage();
        }
    }
}

