/*
 * Decompiled with CFR 0.152.
 */
package frost.util;

import frost.util.FlexibleObserver;
import java.util.Vector;

public class FlexibleObservable {
    private boolean changed = false;
    protected Vector observers = new Vector();

    public synchronized void addObserver(FlexibleObserver flexibleObserver) {
        if (flexibleObserver == null) {
            throw new NullPointerException();
        }
        if (!this.observers.contains(flexibleObserver)) {
            this.observers.addElement(flexibleObserver);
        }
    }

    public synchronized void deleteObserver(FlexibleObserver flexibleObserver) {
        this.observers.removeElement(flexibleObserver);
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object object) {
        Object[] objectArray;
        FlexibleObservable flexibleObservable = this;
        synchronized (flexibleObservable) {
            if (!this.changed) {
                return;
            }
            objectArray = this.observers.toArray();
            this.clearChanged();
        }
        for (int i = objectArray.length - 1; i >= 0; --i) {
            ((FlexibleObserver)objectArray[i]).update(this, object);
        }
    }

    public synchronized void deleteObservers() {
        this.observers.removeAllElements();
    }

    protected synchronized void setChanged() {
        this.changed = true;
    }

    protected synchronized void clearChanged() {
        this.changed = false;
    }

    public synchronized boolean hasChanged() {
        return this.changed;
    }

    public synchronized int countObservers() {
        return this.observers.size();
    }
}

