/*
 * Decompiled with CFR 0.152.
 */
package frost.threads.maintenance;

import frost.Core;
import frost.FileAccess;
import frost.boards.TofTree;
import frost.boards.TofTreeModel;
import frost.gui.objects.Board;
import frost.identities.Identity;
import frost.messages.MessageObject;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResendFailedMessagesThread
extends Thread {
    private static Logger logger = Logger.getLogger(ResendFailedMessagesThread.class.getName());
    private TofTree tofTree;
    private TofTreeModel tofTreeModel;

    public ResendFailedMessagesThread(TofTree tofTree, TofTreeModel tofTreeModel) {
        this.tofTree = tofTree;
        this.tofTreeModel = tofTreeModel;
    }

    public void run() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.isInterrupted()) {
            return;
        }
        logger.info("Starting search for unsent messages ...");
        ArrayList arrayList = FileAccess.getAllEntries(new File(Core.frostSettings.getValue("unsent.dir")), ".xml");
        for (int i = 0; i < arrayList.size(); ++i) {
            File file = (File)arrayList.get(i);
            if (!file.getName().startsWith("unsent")) continue;
            MessageObject messageObject = null;
            try {
                messageObject = new MessageObject(file);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Couldn't read the message file, will not send message.", exception);
            }
            if (messageObject != null && messageObject.isValid()) {
                Board board = this.tofTreeModel.getBoardByName(messageObject.getBoard());
                if (board == null) {
                    logger.warning("Can't resend Message '" + messageObject.getSubject() + "', the target board '" + messageObject.getBoard() + "' was not found in your boardlist.");
                    continue;
                }
                Identity identity = null;
                if (messageObject.getRecipient() != null && messageObject.getRecipient().length() > 0 && (identity = Core.getInstance().getIdentities().getIdentity(messageObject.getRecipient())) == null) {
                    logger.warning("Can't resend Message '" + messageObject.getSubject() + "', the recipient is not longer in your identites file!");
                    continue;
                }
                this.tofTree.getRunningBoardUpdateThreads().startMessageUpload(board, messageObject, null, identity);
                logger.info("Message '" + messageObject.getSubject() + "' will be resent to board '" + board.getName() + "'.");
            }
            file.delete();
        }
        logger.info("Finished search for unsent messages ...");
    }
}

