/*
 * Decompiled with CFR 0.152.
 */
package frost.threads.maintenance;

import frost.Core;
import frost.SettingsClass;
import frost.boards.TofTree;
import frost.boards.TofTreeModel;
import frost.gui.objects.Board;
import frost.threads.BoardUpdateThread;
import frost.threads.maintenance.ClearSpam;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Logger;

public class CheckForSpam
extends TimerTask {
    private static Logger logger = Logger.getLogger(CheckForSpam.class.getName());
    private SettingsClass settings;
    private TofTree tofTree;
    private TofTreeModel tofTreeModel;

    public CheckForSpam(SettingsClass settingsClass, TofTree tofTree, TofTreeModel tofTreeModel) {
        this.settings = settingsClass;
        this.tofTree = tofTree;
        this.tofTreeModel = tofTreeModel;
    }

    public void run() {
        if (this.settings.getBoolValue("doBoardBackoff")) {
            for (Board board : this.tofTreeModel.getAllBoards()) {
                if (board.getBlockedCount() > this.settings.getIntValue("spamTreshold")) {
                    logger.warning("######### board '" + board.getName() + "' is spammed, update stops for 24h ############");
                    board.setSpammed(true);
                    Core.schedule(new ClearSpam(board), 86400000L);
                    Vector vector = this.tofTree.getRunningBoardUpdateThreads().getDownloadThreadsForBoard(board);
                    for (BoardUpdateThread boardUpdateThread : vector) {
                        while (!boardUpdateThread.isInterrupted()) {
                            boardUpdateThread.interrupt();
                        }
                    }
                }
                board.resetBlocked();
            }
        }
    }
}

