/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.Core;
import frost.FileAccess;
import frost.MainFrame;
import frost.Mixed;
import frost.XMLTools;
import frost.XMLizable;
import frost.crypt.MetaData;
import frost.crypt.SignMetaData;
import frost.fcp.FcpInsert;
import frost.fcp.FcpRequest;
import frost.fcp.FcpResults;
import frost.fileTransfer.Index;
import frost.gui.objects.Board;
import frost.identities.FrostIdentities;
import frost.identities.Identity;
import frost.messages.FrostIndex;
import frost.messaging.MessageHashes;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateIdThread
extends Thread {
    private static Logger logger = Logger.getLogger(UpdateIdThread.class.getName());
    private String date;
    private int requestHtl;
    private int insertHtl;
    private String keypool;
    private Board board;
    private String publicKey;
    private String privateKey;
    private String requestKey;
    private String insertKey;
    private static final String fileSeparator = System.getProperty("file.separator");
    private MessageHashes messageHashes;
    private boolean isForToday = false;
    private FrostIdentities identities;
    private IndexSlots indexSlots;
    private static final int MAX_SLOTS_PER_DAY = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadIndexFile() throws Throwable {
        logger.info("FILEDN: UpdateIdThread - makeIndexFile for " + this.board.getName());
        if (this.indexSlots.findFirstFreeUploadSlot() < 0) {
            return true;
        }
        Map map = null;
        Index index = Index.getInstance();
        Object object = index;
        synchronized (object) {
            map = index.getUploadKeys(this.board);
        }
        if (map == null || map.size() == 0) {
            logger.info("FILEDN: No keys to upload, stopping UpdateIdThread for " + this.board.getName());
            return true;
        }
        logger.info("FILEDN: Starting upload of index file to board " + this.board.getName() + "; files=" + map.size());
        object = new FrostIndex(map);
        map = null;
        File file = new File(this.keypool + this.board.getBoardFilename() + "_upload.zip");
        FileAccess.writeZipFile(XMLTools.getRawXMLDocument((XMLizable)object), "entry", file);
        object = null;
        if (!file.isFile() || file.length() == 0L) {
            logger.warning("No index file to upload, save/zip failed.");
            return false;
        }
        boolean bl = this.uploadFile(file);
        if (bl) {
            file.delete();
        }
        return bl;
    }

    private boolean uploadFile(File file) {
        boolean bl = false;
        try {
            boolean bl2 = MainFrame.frostSettings.getBoolValue("signUploads");
            byte[] byArray = null;
            if (bl2) {
                byte[] byArray2 = FileAccess.readByteArray(file);
                SignMetaData signMetaData = new SignMetaData(byArray2, this.identities.getMyId());
                byArray = XMLTools.getRawXMLDocument(signMetaData);
            }
            int n = 0;
            int n2 = this.indexSlots.findFirstFreeUploadSlot();
            while (!bl && n < 3 && n2 > -1) {
                logger.info("Trying index file upload to index " + n2);
                String[] stringArray = FcpInsert.putFile(this.insertKey + n2 + ".idx.sha3.zip", file, byArray, this.insertHtl, false);
                if (stringArray[0].equals("Success")) {
                    bl = true;
                    this.indexSlots.setSlotUsed(n2);
                    logger.info("FILEDN: Index file successfully uploaded.");
                } else {
                    if (stringArray[0].equals("KeyCollision")) {
                        n2 = this.indexSlots.findNextFreeSlot(n2);
                        n = 0;
                        logger.info("FILEDN: Index file collided, increasing index.");
                        continue;
                    }
                    String string = stringArray[0];
                    if (string == null) {
                        string = "";
                    }
                    logger.info("FILEDN: Unknown upload error (#" + n + ", '" + string + "'), retrying.");
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Exception in uploadFile", throwable);
        }
        logger.info("FILEDN: Index file upload finished, file uploaded state is: " + bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            int n = (int)(Math.random() * 2000.0);
            Mixed.wait(n);
            int n2 = this.isForToday ? 3 : 2;
            int n3 = this.indexSlots.findFirstFreeDownloadSlot();
            int n4 = 0;
            while (n4 < n2 && n3 >= 0) {
                File file = File.createTempFile("frost-index-" + n3, this.board.getBoardFilename(), new File(MainFrame.frostSettings.getValue("temp.dir")));
                logger.info("FILEDN: Requesting index " + n3 + " for board " + this.board.getName() + " for date " + this.date);
                FcpResults fcpResults = FcpRequest.getFile(this.requestKey + n3 + ".idx.sha3.zip", null, file, this.requestHtl, false);
                if (fcpResults == null || file.length() == 0L) {
                    file.delete();
                    ++n4;
                    n3 = this.indexSlots.findNextFreeSlot(n3);
                    continue;
                }
                this.indexSlots.setSlotUsed(n3);
                n3 = this.indexSlots.findNextFreeSlot(n3);
                n4 = 0;
                String string = Core.getCrypto().digest(file);
                if (this.messageHashes.contains(string)) {
                    file.delete();
                    continue;
                }
                this.messageHashes.add(string);
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    byte[] byArray = FileAccess.readZipFileBinary(file);
                    if (byArray == null) {
                        logger.warning("Could not extract received zip file, skipping.");
                        file.delete();
                        continue;
                    }
                    File file2 = new File(file.getPath() + "_unzipped");
                    FileAccess.writeFile(byArray, file2);
                    byArray = null;
                    FrostIndex frostIndex = null;
                    try {
                        object4 = object5 = Index.getInstance();
                        synchronized (object4) {
                            frostIndex = ((Index)object5).readKeyFile(file2);
                        }
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, "Could not parse the index file: ", exception);
                    }
                    if (frostIndex == null || frostIndex.getFilesMap().size() == 0) {
                        logger.log(Level.SEVERE, "Received index file invalid or empty, skipping.");
                        file.delete();
                        file2.delete();
                        continue;
                    }
                    object5 = null;
                    object4 = frostIndex.getSharer();
                    if (fcpResults.getRawMetadata() != null) {
                        try {
                            object3 = new SignMetaData(fcpResults.getRawMetadata());
                        }
                        catch (Throwable throwable) {
                            logger.log(Level.SEVERE, "Could not read the XML metadata, skipping file index.", throwable);
                            file.delete();
                            continue;
                        }
                        if (object4 == null) {
                            logger.warning("MetaData present, but file didn't contain an identity :(");
                            file2.delete();
                            file.delete();
                            continue;
                        }
                        object2 = null;
                        object = null;
                        if (((MetaData)object3).getPerson() != null) {
                            object2 = Mixed.makeFilename(((MetaData)object3).getPerson().getUniqueName());
                            object = ((MetaData)object3).getPerson().getKey();
                        }
                        if (object2 == null || ((String)object2).length() == 0 || object == null || ((String)object).length() == 0) {
                            logger.warning("XML metadata have missing fields, skipping file index.");
                            file2.delete();
                            file.delete();
                            continue;
                        }
                        if (!((String)object2).equals(Mixed.makeFilename(((Identity)object4).getUniqueName())) || !((String)object).equals(((Identity)object4).getKey())) {
                            logger.warning("The identity in MetaData didn't match the identity in File! :(\nfile owner : " + ((Identity)object4).getUniqueName() + "\n" + "file key : " + ((Identity)object4).getKey() + "\n" + "meta owner: " + (String)object2 + "\n" + "meta key : " + (String)object);
                            file2.delete();
                            file.delete();
                            continue;
                        }
                        byte[] byArray2 = FileAccess.readByteArray(file);
                        boolean bl = Core.getCrypto().detachedVerify(byArray2, (String)object, ((SignMetaData)object3).getSig());
                        byArray2 = null;
                        if (!bl) {
                            logger.warning("Invalid signature for index file from " + (String)object2);
                            file2.delete();
                            file.delete();
                            continue;
                        }
                        if (this.identities.isMySelf((String)object2)) {
                            logger.info("Received index file from myself");
                            object5 = this.identities.getMyId();
                        } else {
                            logger.info("Received index file from " + (String)object2);
                            object5 = this.identities.getIdentity((String)object2);
                            if (object5 == null) {
                                object5 = this.addNewSharer((String)object2, (String)object);
                                if (object5 == null) {
                                    logger.info("sharer was null... :(");
                                    file2.delete();
                                    file.delete();
                                    continue;
                                }
                            } else if (((Identity)object5).getState() == 4 && MainFrame.frostSettings.getBoolValue("hideBadFiles")) {
                                logger.info("Skipped index file from BAD user " + (String)object2);
                                file.delete();
                                file2.delete();
                                continue;
                            }
                            ((Identity)object5).updateLastSeenTimestamp();
                        }
                    } else if (MainFrame.frostSettings.getBoolValue("hideAnonFiles")) {
                        file2.delete();
                        file.delete();
                        continue;
                    }
                    if (object5 == null || ((Identity)object5).getState() != 1) {
                        object3 = object5 == null ? "Anonymous" : ((Identity)object5).getUniqueName();
                        logger.info("adding only files from " + (String)object3);
                    } else {
                        logger.info("adding all files from " + ((Identity)object5).getUniqueName());
                        object3 = null;
                    }
                    object = object2 = Index.getInstance();
                    synchronized (object) {
                        ((Index)object2).add(frostIndex, this.board, (String)object3);
                    }
                    file.delete();
                    file2.delete();
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, "Error in UpdateIdThread", throwable);
                }
            }
            if (!this.isInterrupted() && this.isForToday) {
                try {
                    this.uploadIndexFile();
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, "Exception during uploadIndexFile()", throwable);
                }
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Oo. EXCEPTION in UpdateIdThread", throwable);
        }
        this.indexSlots.saveSlotsFile();
    }

    private Identity addNewSharer(String string, String string2) {
        String string3 = string.substring(string.indexOf("@") + 1, string.length()).trim();
        String string4 = Core.getCrypto().digest(string2.trim()).trim();
        string4 = Mixed.makeFilename(string4).trim();
        if (!Mixed.makeFilename(string3).equals(string4)) {
            logger.warning("Warning: public key of sharer didn't match its digest:\ngiven digest :'" + string3 + "'\n" + "pubkey       :'" + string2.trim() + "'\n" + "calc. digest :'" + string4 + "'");
            return null;
        }
        Identity identity = new Identity(string.substring(0, string.indexOf("@")), string2);
        identity.setState(2);
        this.identities.addIdentity(identity);
        return identity;
    }

    public UpdateIdThread(Board board, String string, FrostIdentities frostIdentities, boolean bl) {
        this.board = board;
        this.date = string;
        this.identities = frostIdentities;
        this.requestHtl = MainFrame.frostSettings.getIntValue("keyDownloadHtl");
        this.insertHtl = MainFrame.frostSettings.getIntValue("keyUploadHtl");
        this.keypool = MainFrame.frostSettings.getValue("keypool.dir");
        this.isForToday = bl;
        this.indexSlots = new IndexSlots(board, string, 100);
        this.publicKey = board.getPublicKey();
        this.privateKey = board.getPrivateKey();
        this.requestKey = !board.isPublicBoard() && this.publicKey != null ? new StringBuffer().append(this.publicKey).append("/").append(string).append("/").toString() : new StringBuffer().append("KSK@frost/index/").append(board.getBoardFilename()).append("/").append(string).append("/").toString();
        this.insertKey = !board.isPublicBoard() && this.privateKey != null ? new StringBuffer().append(this.privateKey).append("/").append(string).append("/").toString() : new StringBuffer().append("KSK@frost/index/").append(board.getBoardFilename()).append("/").append(string).append("/").toString();
    }

    public void setMessageHashes(MessageHashes messageHashes) {
        this.messageHashes = messageHashes;
    }

    private static class IndexSlots {
        private static final Integer EMPTY = new Integer(0);
        private static final Integer USED = new Integer(-1);
        private int maxSlotsPerDay;
        private Vector slots;
        private File slotsFile;
        private Board targetBoard;

        public IndexSlots(Board board, String string, int n) {
            this.targetBoard = board;
            this.maxSlotsPerDay = n;
            this.slotsFile = new File(MainFrame.keypool + this.targetBoard.getBoardFilename() + fileSeparator + "indicesV2-" + string);
            this.loadSlotsFile(string);
        }

        private void loadSlotsFile(String string) {
            if (this.slotsFile.isFile()) {
                try {
                    String string2;
                    this.slots = new Vector();
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(this.slotsFile));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        if ((string2 = string2.trim()).length() == 0) continue;
                        if (string2.equals("-1")) {
                            this.slots.add(USED);
                        } else {
                            this.slots.add(EMPTY);
                        }
                        if (this.slots.size() < this.maxSlotsPerDay) continue;
                    }
                    bufferedReader.close();
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, "Exception thrown in loadIndex(String date) - Date: '" + string + "' - Board name: '" + this.targetBoard.getBoardFilename() + "'", throwable);
                }
            }
            if (this.slots == null) {
                this.slots = new Vector();
            }
            for (int i = this.slots.size(); i < this.maxSlotsPerDay; ++i) {
                this.slots.add(EMPTY);
            }
        }

        private boolean isTargetBoardValid() {
            File file = new File(MainFrame.keypool + this.targetBoard.getBoardFilename());
            return file.isDirectory();
        }

        public void saveSlotsFile() {
            if (!this.isTargetBoardValid()) {
                return;
            }
            try {
                this.slotsFile.delete();
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.slotsFile)));
                for (int i = 0; i < this.slots.size(); ++i) {
                    Integer n = (Integer)this.slots.elementAt(i);
                    printWriter.println("" + n);
                }
                printWriter.flush();
                printWriter.close();
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Exception thrown in saveSlotsFile()", throwable);
            }
        }

        public int findFirstFreeDownloadSlot() {
            for (int i = 0; i < this.slots.size(); ++i) {
                Integer n = (Integer)this.slots.elementAt(i);
                if (n <= -1) continue;
                return i;
            }
            return -1;
        }

        public int findFirstFreeUploadSlot() {
            for (int i = this.slots.size() - 1; i >= 0; --i) {
                Integer n = (Integer)this.slots.elementAt(i);
                if (n >= 0) continue;
                if (i + 1 < this.slots.size()) {
                    return i + 1;
                }
                return -1;
            }
            return 0;
        }

        public int findNextFreeSlot(int n) {
            for (int i = n + 1; i < this.slots.size(); ++i) {
                Integer n2 = (Integer)this.slots.elementAt(i);
                if (n2 <= -1) continue;
                return i;
            }
            return -1;
        }

        public void setSlotUsed(int n) {
            int n2 = (Integer)this.slots.elementAt(n);
            if (n2 < 0) {
                logger.severe("WARNING - index sequence screwed in setSlotUsed. report to a dev");
                return;
            }
            this.slots.setElementAt(USED, n);
        }
    }
}

