/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.DateFun;
import frost.MainFrame;
import frost.SettingsClass;
import frost.gui.objects.Board;
import frost.identities.FrostIdentities;
import frost.identities.Identity;
import frost.messages.MessageObject;
import frost.messaging.MessageHashes;
import frost.threads.BoardUpdateThread;
import frost.threads.BoardUpdateThreadListener;
import frost.threads.BoardUpdateThreadObject;
import frost.threads.MessageDownloadThread;
import frost.threads.MessageUploadThread;
import frost.threads.UpdateIdThread;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;

public class RunningBoardUpdateThreads
implements BoardUpdateThreadListener {
    private static Logger logger = Logger.getLogger(RunningBoardUpdateThreads.class.getName());
    private JFrame parentFrame;
    private FrostIdentities identities;
    private SettingsClass frostSettings;
    Hashtable threadListenersForBoard = null;
    Vector threadListenersForAllBoards = null;
    Hashtable runningDownloadThreads = null;
    Hashtable runningUploadThreads = null;
    private MessageHashes messageHashes;

    public RunningBoardUpdateThreads(JFrame jFrame, FrostIdentities frostIdentities, SettingsClass settingsClass) {
        this.parentFrame = jFrame;
        this.identities = frostIdentities;
        this.frostSettings = settingsClass;
        this.threadListenersForBoard = new Hashtable();
        this.threadListenersForAllBoards = new Vector();
        this.runningDownloadThreads = new Hashtable();
        this.runningUploadThreads = new Hashtable();
    }

    public boolean startMessageDownloadToday(Board board, SettingsClass settingsClass, BoardUpdateThreadListener boardUpdateThreadListener) {
        MessageDownloadThread messageDownloadThread = new MessageDownloadThread(true, board, settingsClass.getIntValue("tofDownloadHtl"), settingsClass.getValue("keypool.dir"), settingsClass.getValue("maxMessageDownload"), this.identities);
        messageDownloadThread.setMessageHashes(this.messageHashes);
        messageDownloadThread.addBoardUpdateThreadListener(this);
        if (boardUpdateThreadListener != null) {
            messageDownloadThread.addBoardUpdateThreadListener(boardUpdateThreadListener);
        }
        this.getVectorFromHashtable(this.runningDownloadThreads, board).add(messageDownloadThread);
        messageDownloadThread.start();
        return true;
    }

    public boolean startMessageDownloadBack(Board board, SettingsClass settingsClass, BoardUpdateThreadListener boardUpdateThreadListener) {
        MessageDownloadThread messageDownloadThread = new MessageDownloadThread(false, board, settingsClass.getIntValue("tofDownloadHtl"), settingsClass.getValue("keypool.dir"), settingsClass.getValue("maxMessageDownload"), this.identities);
        messageDownloadThread.setMessageHashes(this.messageHashes);
        messageDownloadThread.addBoardUpdateThreadListener(this);
        if (boardUpdateThreadListener != null) {
            messageDownloadThread.addBoardUpdateThreadListener(boardUpdateThreadListener);
        }
        this.getVectorFromHashtable(this.runningDownloadThreads, board).add(messageDownloadThread);
        messageDownloadThread.start();
        return true;
    }

    public boolean startBoardFilesUpload(Board board, SettingsClass settingsClass, BoardUpdateThreadListener boardUpdateThreadListener) {
        return true;
    }

    public boolean startBoardFilesDownload(Board board, SettingsClass settingsClass, BoardUpdateThreadListener boardUpdateThreadListener) {
        BoardFilesDownloadStarter boardFilesDownloadStarter = new BoardFilesDownloadStarter(board, this.identities);
        boardFilesDownloadStarter.addBoardUpdateThreadListener(this);
        if (boardUpdateThreadListener != null) {
            boardFilesDownloadStarter.addBoardUpdateThreadListener(boardUpdateThreadListener);
        }
        this.getVectorFromHashtable(this.runningDownloadThreads, board).add(boardFilesDownloadStarter);
        boardFilesDownloadStarter.start();
        return true;
    }

    public boolean startMessageUpload(Board board, MessageObject messageObject, BoardUpdateThreadListener boardUpdateThreadListener, Identity identity) {
        MessageUploadThread messageUploadThread = new MessageUploadThread(board, messageObject, this.identities, this.frostSettings, identity);
        messageUploadThread.setParentFrame(this.parentFrame);
        messageUploadThread.addBoardUpdateThreadListener(this);
        if (boardUpdateThreadListener != null) {
            messageUploadThread.addBoardUpdateThreadListener(boardUpdateThreadListener);
        }
        this.getVectorFromHashtable(this.runningUploadThreads, board).add(messageUploadThread);
        messageUploadThread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getVectorFromHashtable(Hashtable hashtable, Board board) {
        Vector vector = null;
        Hashtable hashtable2 = hashtable;
        synchronized (hashtable2) {
            vector = (Vector)hashtable.get(board.getName());
            if (vector == null) {
                vector = new Vector();
                hashtable.put(board.getName(), vector);
            }
        }
        return vector;
    }

    public Vector getDownloadThreadsForBoard(Board board) {
        return this.getVectorFromHashtable(this.runningDownloadThreads, board);
    }

    public Vector getUploadThreadsForBoard(Board board) {
        return this.getVectorFromHashtable(this.runningUploadThreads, board);
    }

    public void addBoardUpdateThreadListener(Board board, BoardUpdateThreadListener boardUpdateThreadListener) {
        this.getVectorFromHashtable(this.threadListenersForBoard, board).remove(boardUpdateThreadListener);
        this.getVectorFromHashtable(this.threadListenersForBoard, board).add(boardUpdateThreadListener);
    }

    public void addBoardUpdateThreadListener(BoardUpdateThreadListener boardUpdateThreadListener) {
        this.threadListenersForAllBoards.remove(boardUpdateThreadListener);
        this.threadListenersForAllBoards.add(boardUpdateThreadListener);
    }

    public void removeBoardUpdateThreadListener(Board board, BoardUpdateThreadListener boardUpdateThreadListener) {
        this.getVectorFromHashtable(this.threadListenersForBoard, board).remove(boardUpdateThreadListener);
    }

    public void removeBoardUpdateThreadListener(BoardUpdateThreadListener boardUpdateThreadListener) {
        this.threadListenersForAllBoards.remove(boardUpdateThreadListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boardUpdateThreadFinished(BoardUpdateThread boardUpdateThread) {
        Vector vector = boardUpdateThread.getThreadType() == 4 ? this.getVectorFromHashtable(this.runningUploadThreads, boardUpdateThread.getTargetBoard()) : this.getVectorFromHashtable(this.runningDownloadThreads, boardUpdateThread.getTargetBoard());
        if (vector != null) {
            vector.remove(boardUpdateThread);
        }
        Vector vector2 = this.threadListenersForAllBoards;
        synchronized (vector2) {
            Iterator iterator = this.threadListenersForAllBoards.iterator();
            while (iterator.hasNext()) {
                ((BoardUpdateThreadListener)iterator.next()).boardUpdateThreadFinished(boardUpdateThread);
            }
            iterator = this.getVectorFromHashtable(this.threadListenersForBoard, boardUpdateThread.getTargetBoard()).iterator();
            while (iterator.hasNext()) {
                ((BoardUpdateThreadListener)iterator.next()).boardUpdateThreadFinished(boardUpdateThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void boardUpdateThreadStarted(BoardUpdateThread boardUpdateThread) {
        Vector vector = this.threadListenersForAllBoards;
        synchronized (vector) {
            Iterator iterator = this.threadListenersForAllBoards.iterator();
            while (iterator.hasNext()) {
                ((BoardUpdateThreadListener)iterator.next()).boardUpdateThreadStarted(boardUpdateThread);
            }
            iterator = this.getVectorFromHashtable(this.threadListenersForBoard, boardUpdateThread.getTargetBoard()).iterator();
            while (iterator.hasNext()) {
                ((BoardUpdateThreadListener)iterator.next()).boardUpdateThreadStarted(boardUpdateThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningDownloadThreadCount() {
        int n = 0;
        Hashtable hashtable = this.runningDownloadThreads;
        synchronized (hashtable) {
            for (Object v : this.runningDownloadThreads.values()) {
                Vector vector;
                if (!(v instanceof Vector) || (vector = (Vector)v).size() <= 0) continue;
                n += vector.size();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRunningUploadThreadCount() {
        int n = 0;
        Hashtable hashtable = this.runningDownloadThreads;
        synchronized (hashtable) {
            for (Object v : this.runningUploadThreads.values()) {
                Vector vector;
                if (!(v instanceof Vector) || (vector = (Vector)v).size() <= 0) continue;
                n += vector.size();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUpdatingBoardCount() {
        int n = 0;
        Hashtable hashtable = this.runningDownloadThreads;
        synchronized (hashtable) {
            for (Object v : this.runningDownloadThreads.values()) {
                Vector vector;
                if (!(v instanceof Vector) || (vector = (Vector)v).size() <= 0) continue;
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUploadingBoardCount() {
        int n = 0;
        Hashtable hashtable = this.runningDownloadThreads;
        synchronized (hashtable) {
            for (Object v : this.runningUploadThreads.values()) {
                Vector vector;
                if (!(v instanceof Vector) || (vector = (Vector)v).size() <= 0) continue;
                ++n;
            }
        }
        return n;
    }

    public boolean isUpdating(Board board) {
        return this.getVectorFromHashtable(this.runningDownloadThreads, board).size() > 0;
    }

    public boolean isUploading(Board board) {
        return this.getVectorFromHashtable(this.runningUploadThreads, board).size() > 0;
    }

    public boolean isThreadOfTypeRunning(Board board, int n) {
        Vector vector = this.getDownloadThreadsForBoard(board);
        for (int i = 0; i < vector.size(); ++i) {
            BoardUpdateThread boardUpdateThread = (BoardUpdateThread)vector.get(i);
            if (boardUpdateThread.getThreadType() != n) continue;
            return true;
        }
        return false;
    }

    public void setMessageHashes(MessageHashes messageHashes) {
        this.messageHashes = messageHashes;
    }

    private class BoardFilesDownloadStarter
    extends BoardUpdateThreadObject
    implements BoardUpdateThread {
        Board board;
        FrostIdentities newIdentities;

        public BoardFilesDownloadStarter(Board board, FrostIdentities frostIdentities) {
            super(board, frostIdentities);
            this.newIdentities = frostIdentities;
            this.board = board;
        }

        public int getThreadType() {
            return 5;
        }

        public void run() {
            this.notifyThreadStarted(this);
            int n = MainFrame.frostSettings.getIntValue("maxMessageDownload");
            try {
                for (int i = 0; i < n; ++i) {
                    boolean bl = i == 0;
                    UpdateIdThread updateIdThread = new UpdateIdThread(this.board, DateFun.getDate(i), this.newIdentities, bl);
                    updateIdThread.setMessageHashes(RunningBoardUpdateThreads.this.messageHashes);
                    updateIdThread.run();
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Exception in BoardFilesDownloadStarter for() loop", throwable);
            }
            this.notifyThreadFinished(this);
        }
    }
}

