/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import com.sun.mail.smtp.SMTPMessage;
import com.sun.mail.smtp.SMTPTransport;
import frost.Core;
import frost.FileAccess;
import frost.Mixed;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.util.FlexibleObserver;
import java.io.File;
import java.util.LinkedList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class NotifyByEmailThread
extends Thread
implements FlexibleObserver {
    private static String template;
    private static final String nameTag = "<filename>";
    private static final String subject = "[Frost] Download finished";
    private static Logger logger;
    private static String SMTPServer;
    private static String SMTPuser;
    private static String SMTPpass;
    private static String notifyAddress;
    private LinkedList queue = new LinkedList();
    private SMTPMessage message;
    private InternetAddress address;
    private Session session;
    private Properties sessionProperties;
    private SMTPTransport transport;

    public NotifyByEmailThread() throws Error {
        this.setDaemon(true);
        File file = new File("email");
        if (file.exists() && file.isFile() && file.length() > 0L && file.length() < 65536L) {
            template = FileAccess.readFile(file.getPath());
        } else {
            template = "Hello\n, this is the automatic Frost email notifier. The download of file <filename> has completed.\n\n";
            FileAccess.writeFile(template, file);
        }
        SMTPServer = Core.frostSettings.getValue("SMTP.server");
        SMTPuser = Core.frostSettings.getValue("SMTP.user");
        SMTPpass = Core.frostSettings.getValue("SMTP.pass");
        notifyAddress = Core.frostSettings.getValue("notifyAddress");
        if (SMTPServer == null || SMTPuser == null || SMTPpass == null || notifyAddress == null || SMTPServer.length() == 0 || SMTPuser.length() == 0 || SMTPpass.length() == 0 || notifyAddress.length() == 0) {
            throw new Error("invalid SMTP parameters");
        }
        this.sessionProperties = new Properties();
        this.sessionProperties.setProperty("mail.host", SMTPServer);
        this.sessionProperties.setProperty("mail.user", SMTPpass);
        this.session = Session.getInstance(this.sessionProperties);
        this.transport = new SMTPTransport(this.session, new URLName("frostNotifier"));
        try {
            this.address = new InternetAddress(notifyAddress);
            this.address.validate();
        }
        catch (AddressException addressException) {
            throw new Error("invalid email address");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            String string;
            Object object = this.queue;
            synchronized (object) {
                if (this.queue.size() == 0) {
                    try {
                        this.queue.wait();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                string = (String)this.queue.removeFirst();
            }
            logger.info("notifying for received file " + string);
            object = template.replaceAll(nameTag, string);
            if (!this.transport.isConnected()) {
                try {
                    this.transport.connect(SMTPServer, SMTPuser, SMTPpass);
                }
                catch (MessagingException messagingException) {
                    logger.log(Level.SEVERE, "couldn't connect to smtp server", messagingException);
                    Mixed.wait(300000);
                    this.queue.addFirst(string);
                    continue;
                }
            }
            this.message = new SMTPMessage(this.session);
            this.message.setNotifyOptions(-1);
            this.message.setReturnOption(-1);
            try {
                this.message.setEnvelopeFrom("Frost");
                this.message.setSubject(subject);
                this.message.setText((String)object);
                this.transport.sendMessage(this.message, new Address[]{this.address});
                logger.info("message sent successfully");
                if (this.queue.size() != 0) continue;
                this.transport.close();
            }
            catch (SendFailedException sendFailedException) {
                logger.log(Level.SEVERE, "Exception thrown in run()", sendFailedException);
                Mixed.wait(300000);
                this.queue.addFirst(string);
            }
            catch (MessagingException messagingException) {
                logger.log(Level.SEVERE, "Exception thrown in run()", messagingException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object object, Object object2) {
        assert (object instanceof FrostDownloadItem && object2 instanceof String) : "incorrect parameters at email notifier";
        LinkedList linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.add(object2);
            this.queue.notifyAll();
        }
    }

    public static String getTemplate() {
        return template;
    }

    public static void setSMTPpass(String string) {
        SMTPpass = string;
    }

    public static void setSMTPServer(String string) {
        SMTPServer = string;
    }

    public static void setSMTPuser(String string) {
        SMTPuser = string;
    }

    public static void setTemplate(String string) {
        template = string;
    }

    static {
        logger = Logger.getLogger(NotifyByEmailThread.class.getName());
    }
}

