/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.Core;
import frost.DateFun;
import frost.FileAccess;
import frost.Mixed;
import frost.SettingsClass;
import frost.XMLTools;
import frost.XMLizable;
import frost.crypt.EncryptMetaData;
import frost.crypt.SignMetaData;
import frost.fcp.FcpInsert;
import frost.fcp.FcpRequest;
import frost.fcp.FecSplitfile;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.gui.MessageUploadFailedDialog;
import frost.gui.objects.Board;
import frost.identities.FrostIdentities;
import frost.identities.Identity;
import frost.messages.Attachment;
import frost.messages.AttachmentList;
import frost.messages.FECRedirectFileObject;
import frost.messages.MessageObject;
import frost.messages.SharedFileObject;
import frost.threads.BoardUpdateThread;
import frost.threads.BoardUpdateThreadObject;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;

public class MessageUploadThread
extends BoardUpdateThreadObject
implements BoardUpdateThread {
    private static Logger logger = Logger.getLogger(MessageUploadThread.class.getName());
    private SettingsClass frostSettings;
    private JFrame parentFrame;
    private Board board;
    private String destinationBase;
    private String keypool;
    private MessageObject message;
    private File messageFile;
    private int messageUploadHtl;
    private String privateKey;
    private String publicKey;
    private boolean secure;
    private byte[] signMetadata;
    private File zipFile;
    private Identity encryptForRecipient;

    public MessageUploadThread(Board board, MessageObject messageObject, FrostIdentities frostIdentities, SettingsClass settingsClass) {
        this(board, messageObject, frostIdentities, settingsClass, null);
    }

    public MessageUploadThread(Board board, MessageObject messageObject, FrostIdentities frostIdentities, SettingsClass settingsClass, Identity identity) {
        super(board, frostIdentities);
        this.board = board;
        this.message = messageObject;
        this.frostSettings = settingsClass;
        this.encryptForRecipient = identity;
        if (messageObject.getDate() == "" || !messageObject.getDate().equals(DateFun.getDate())) {
            messageObject.setTime(DateFun.getFullExtendedTime() + "GMT");
            messageObject.setDate(DateFun.getDate());
        }
        this.messageUploadHtl = settingsClass.getIntValue("tofUploadHtl");
        this.keypool = settingsClass.getValue("keypool.dir");
        String string = new StringBuffer().append(settingsClass.getValue("unsent.dir")).append("unsent").append(String.valueOf(System.currentTimeMillis())).append(".xml").toString();
        this.messageFile = new File(string);
    }

    private boolean checkLocalMessage(File file) {
        try {
            MessageObject messageObject = new MessageObject(file);
            if (!messageObject.getContent().equals(this.message.getContent())) {
                return false;
            }
            if (!messageObject.getSubject().equals(this.message.getSubject())) {
                return false;
            }
            if (!messageObject.getFrom().equals(this.message.getFrom())) {
                return false;
            }
            AttachmentList attachmentList = this.message.getAllAttachments();
            AttachmentList attachmentList2 = messageObject.getAllAttachments();
            if (attachmentList.size() != attachmentList2.size()) {
                return false;
            }
            Iterator iterator = attachmentList.iterator();
            Iterator iterator2 = attachmentList2.iterator();
            while (iterator.hasNext()) {
                Attachment attachment;
                Attachment attachment2 = (Attachment)iterator.next();
                if (attachment2.compareTo(attachment = (Attachment)iterator2.next()) == 0) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Handled Exception in checkLocalMessage", exception);
            return false;
        }
    }

    private boolean checkRemoteFile(String string) {
        try {
            File file = new File(this.messageFile.getPath() + ".coll");
            file.delete();
            file.deleteOnExit();
            FcpRequest.getFile(string, null, file, this.messageUploadHtl, false, false);
            if (file.length() > 0L) {
                if (this.encryptForRecipient != null) {
                    boolean bl = FileAccess.compareFiles(this.zipFile, file);
                    return bl;
                }
                byte[] byArray = FileAccess.readZipFileBinary(file);
                if (byArray == null) {
                    return false;
                }
                FileAccess.writeFile(byArray, file);
                return this.checkLocalMessage(file);
            }
            return false;
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Handled exception in checkRemoteFile", throwable);
            return false;
        }
    }

    private String composeDownKey(int n) {
        String string = this.secure ? new StringBuffer().append(this.publicKey).append("/").append(this.board.getBoardFilename()).append("/").append(this.message.getDate()).append("-").append(n).append(".xml").toString() : new StringBuffer().append("KSK@frost/message/").append(this.frostSettings.getValue("messageBase")).append("/").append(this.message.getDate()).append("-").append(this.board.getBoardFilename()).append("-").append(n).append(".xml").toString();
        return string;
    }

    private String composeUpKey(int n) {
        String string = this.secure ? new StringBuffer().append(this.privateKey).append("/").append(this.board.getBoardFilename()).append("/").append(this.message.getDate()).append("-").append(n).append(".xml").toString() : new StringBuffer().append("KSK@frost/message/").append(this.frostSettings.getValue("messageBase")).append("/").append(this.message.getDate()).append("-").append(this.board.getBoardFilename()).append("-").append(n).append(".xml").toString();
        return string;
    }

    private String getDestinationBase() {
        if (this.destinationBase == null) {
            String string = System.getProperty("file.separator");
            this.destinationBase = new StringBuffer().append(this.keypool).append(this.board.getBoardFilename()).append(string).append(DateFun.getDate()).append(string).toString();
            File file = new File(this.destinationBase);
            if (!file.exists()) {
                file.mkdirs();
            }
        }
        return this.destinationBase;
    }

    public int getThreadType() {
        return 4;
    }

    private boolean initialize() {
        Object object;
        String string;
        if (this.board.isWriteAccessBoard()) {
            this.privateKey = this.board.getPrivateKey();
            this.publicKey = this.board.getPublicKey();
            this.secure = true;
        } else {
            this.secure = false;
        }
        logger.info("TOFUP: Uploading message to board '" + this.board.getName() + "' with HTL " + this.messageUploadHtl);
        if (!this.saveMessage(this.message, this.messageFile)) {
            logger.severe("This was a HARD error and the file to upload is lost, please report to a dev!");
            return false;
        }
        if (!this.uploadAttachments(this.message, this.messageFile)) {
            return false;
        }
        this.zipFile = new File(this.messageFile.getPath() + ".upltmp");
        this.zipFile.delete();
        this.zipFile.deleteOnExit();
        FileAccess.writeZipFile(FileAccess.readByteArray(this.messageFile), "entry", this.zipFile);
        if (!this.zipFile.isFile() || this.zipFile.length() == 0L) {
            logger.severe("Error: zip of message xml file failed, result file not existing or empty. Please report to a dev!");
            return false;
        }
        String string2 = this.message.getFrom();
        if (string2.equals(string = this.identities.getMyId().getUniqueName()) || string2.equals(Mixed.makeFilename(string))) {
            byte[] byArray = FileAccess.readByteArray(this.zipFile);
            if (this.encryptForRecipient != null) {
                byte[] byArray2 = Core.getCrypto().encrypt(byArray, this.encryptForRecipient.getKey());
                if (byArray2 == null) {
                    logger.severe("Error: could not encrypt the message, please report to a dev!");
                    return false;
                }
                this.zipFile.delete();
                FileAccess.writeFile(byArray2, this.zipFile);
                object = new EncryptMetaData(byArray2, this.identities.getMyId(), this.encryptForRecipient.getUniqueName());
                this.signMetadata = XMLTools.getRawXMLDocument((XMLizable)object);
            } else {
                SignMetaData signMetaData = new SignMetaData(byArray, this.identities.getMyId());
                this.signMetadata = XMLTools.getRawXMLDocument(signMetaData);
            }
        } else if (this.encryptForRecipient != null) {
            logger.log(Level.SEVERE, "TOFUP: ALERT - can't encrypt message if sender is Anonymous! Will not send message!");
            return false;
        }
        long l = this.zipFile.length();
        if (this.signMetadata != null) {
            l += (long)this.signMetadata.length;
        }
        if (l > 32767L) {
            object = "<html>The data you want to upload is too large (" + l + "), " + Short.MAX_VALUE + " is allowed.<br>" + "This should never happen, please report this to a Frost developer!</html>";
            JOptionPane.showMessageDialog(this.parentFrame, object, "Error: message too large", 0);
            return false;
        }
        return true;
    }

    public void run() {
        this.notifyThreadStarted(this);
        boolean bl = true;
        try {
            if (this.initialize()) {
                while (bl) {
                    bl = this.uploadMessage();
                }
            }
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "ERROR: MessageUploadThread.run(): unexpected IOException, terminating thread ...", iOException);
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Oo. EXCEPTION in MessageUploadThread", throwable);
        }
        this.notifyThreadFinished(this);
    }

    public void setParentFrame(JFrame jFrame) {
        this.parentFrame = jFrame;
    }

    private boolean saveMessage(MessageObject messageObject, File file) {
        File file2 = new File(file.getPath() + ".tmp");
        boolean bl = false;
        try {
            Document document = XMLTools.createDomDocument();
            document.appendChild(messageObject.getXMLElement(document));
            bl = XMLTools.writeXmlFile(document, file2.getPath());
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Exception thrown in saveMessage()", throwable);
        }
        if (bl && file2.length() > 0L) {
            this.messageFile.delete();
            file2.renameTo(this.messageFile);
            return true;
        }
        file2.delete();
        return false;
    }

    private boolean uploadAttachment(SharedFileObject sharedFileObject) {
        assert (sharedFileObject.getFile() != null) : "message.getOfflineFiles() failed!";
        String[] stringArray = new String[]{"", ""};
        int n = this.frostSettings.getIntValue("htlUpload");
        logger.info("TOFUP: Uploading attachment " + sharedFileObject.getFile().getPath() + " with HTL " + n);
        int n2 = 3;
        for (int i = 0; i < n2 && !stringArray[0].equals("KeyCollision") && !stringArray[0].equals("Success"); ++i) {
            try {
                stringArray = FcpInsert.putFile("CHK@", sharedFileObject.getFile(), null, n, true, new FrostUploadItem(null, null));
                continue;
            }
            catch (Exception exception) {
                stringArray = new String[]{"Error"};
            }
        }
        if (stringArray[0].equals("KeyCollision") || stringArray[0].equals("Success")) {
            logger.info("TOFUP: Upload of attachment '" + sharedFileObject.getFile().getPath() + "' was successful.");
            String string = stringArray[1];
            sharedFileObject.setKey(string);
            sharedFileObject.setFilename(sharedFileObject.getFile().getName());
            if (sharedFileObject instanceof FECRedirectFileObject) {
                logger.fine("attaching redirect to file " + sharedFileObject.getFile().getName());
                FecSplitfile fecSplitfile = new FecSplitfile(sharedFileObject.getFile());
                if (!fecSplitfile.uploadInit()) {
                    throw new Error("file was just uploaded, but .redirect missing!");
                }
                ((FECRedirectFileObject)sharedFileObject).setRedirect(new String(FileAccess.readByteArray(fecSplitfile.getRedirectFile())));
                fecSplitfile.finishUpload(true);
            } else {
                logger.fine("not attaching redirect");
            }
            sharedFileObject.setFile(null);
            return true;
        }
        logger.warning("TOFUP: Upload of attachment '" + sharedFileObject.getFile().getPath() + "' was NOT successful.");
        return false;
    }

    private boolean uploadAttachments(MessageObject messageObject, File file) {
        boolean bl = true;
        List list = messageObject.getOfflineFiles();
        for (SharedFileObject sharedFileObject : list) {
            if (this.uploadAttachment(sharedFileObject)) {
                this.saveMessage(messageObject, file);
                continue;
            }
            bl = false;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(this.parentFrame, "One or more attachments failed to upload.\nWill retry to upload attachments and message on next startup.", "Attachment upload failed", 0);
        }
        return bl;
    }

    private String composeMsgFilename(int n) {
        return new StringBuffer().append(this.getDestinationBase()).append(this.message.getDate()).append("-").append(this.board.getBoardFilename()).append("-").append(n).append(".xml").toString();
    }

    private int findNextFreeIndex(int n) {
        int n2 = n;
        int n3 = -1;
        logger.fine("TOFUP: Searching free index in board " + this.board.getBoardFilename() + ", starting at index " + n);
        while (true) {
            String string;
            File file;
            if ((file = new File(string = this.composeMsgFilename(n2))).exists() && file.length() > 0L) {
                if (this.encryptForRecipient == null && this.checkLocalMessage(file)) {
                    return -1;
                }
                ++n2;
                n3 = -1;
                continue;
            }
            if (n3 >= 0) {
                if (n2 - n3 > 3) {
                    break;
                }
            } else {
                n3 = n2;
            }
            ++n2;
        }
        logger.fine("TOFUP: Found free index in board " + this.board.getBoardFilename() + " at " + n3);
        return n3;
    }

    private boolean uploadMessage() throws IOException {
        boolean bl;
        boolean bl2 = false;
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        boolean bl3 = false;
        while (!bl2) {
            if ((n = this.findNextFreeIndex(n)) < 0) {
                logger.info("TOFUP: Message seems to be already uploaded (1)");
                bl2 = true;
                continue;
            }
            File file = new File(this.composeMsgFilename(n) + ".lock");
            boolean bl4 = false;
            bl4 = file.createNewFile();
            if (!bl4) {
                logger.fine("TOFUP: Other thread tries this index, increasing index to " + ++n);
                continue;
            }
            file.deleteOnExit();
            String[] stringArray = new String[2];
            String string = this.composeUpKey(n);
            String string2 = this.composeDownKey(n);
            try {
                stringArray = FcpInsert.putFile(string, this.zipFile, this.signMetadata, this.messageUploadHtl, false);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "TOFUP: Error in run()/FcpInsert.putFile", throwable);
            }
            if (stringArray == null || stringArray[0] == null || stringArray[1] == null) {
                stringArray[0] = "Error";
                stringArray[1] = "Error";
            }
            if (stringArray[0].equals("Success")) {
                bl2 = true;
            } else if (stringArray[0].equals("KeyCollision")) {
                if (this.checkRemoteFile(string2)) {
                    logger.info("TOFUP: Message seems to be already uploaded (2)");
                    bl2 = true;
                } else {
                    logger.fine("TOFUP: Upload collided, increasing index to " + ++n);
                }
            } else if (n2 > n3) {
                bl2 = true;
                bl3 = true;
            } else {
                logger.info("TOFUP: Upload failed (try no. " + n2 + " of " + n3 + "), retrying index " + n);
                ++n2;
            }
            if (!bl4) continue;
            file.delete();
        }
        if (!bl3) {
            this.messageFile.delete();
            this.zipFile.delete();
            logger.info("*********************************************************************\nMessage successfully uploaded to board '" + this.board.getName() + "'.\n" + "*********************************************************************");
            bl = false;
        } else {
            logger.warning("TOFUP: Error while uploading message.");
            boolean bl5 = this.frostSettings.getBoolValue("silentlyRetryMessages");
            if (!bl5) {
                MessageUploadFailedDialog messageUploadFailedDialog = new MessageUploadFailedDialog(this.parentFrame);
                int n4 = messageUploadFailedDialog.startDialog();
                if (n4 == 1) {
                    logger.info("TOFUP: Will try to upload again.");
                    bl = true;
                } else if (n4 == 2) {
                    this.zipFile.delete();
                    logger.info("TOFUP: Will try to upload again on next startup.");
                    bl = false;
                } else if (n4 == 3) {
                    this.zipFile.delete();
                    this.messageFile.delete();
                    logger.warning("TOFUP: Will NOT try to upload message again.");
                    bl = false;
                } else {
                    logger.warning("TOFUP: Paranoia - will try to upload message again.");
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        logger.info("TOFUP: Upload Thread finished");
        return bl;
    }
}

