/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.Core;
import frost.DateFun;
import frost.FileAccess;
import frost.MainFrame;
import frost.Mixed;
import frost.XMLTools;
import frost.boards.TOF;
import frost.crypt.EncryptMetaData;
import frost.crypt.MetaData;
import frost.crypt.SignMetaData;
import frost.fcp.FcpRequest;
import frost.fcp.FcpResults;
import frost.fileTransfer.Index;
import frost.gui.objects.Board;
import frost.identities.FrostIdentities;
import frost.identities.Identity;
import frost.messages.FileAttachment;
import frost.messages.SharedFileObject;
import frost.messages.VerifyableMessageObject;
import frost.messaging.MessageHashes;
import frost.threads.BoardUpdateThread;
import frost.threads.BoardUpdateThreadObject;
import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class MessageDownloadThread
extends BoardUpdateThreadObject
implements BoardUpdateThread {
    private Board board;
    private int downloadHtl;
    private String keypool;
    private int maxMessageDownload;
    private String destination;
    private boolean secure;
    private String publicKey;
    private boolean flagNew;
    private static Logger logger = Logger.getLogger(MessageDownloadThread.class.getName());
    private MessageHashes messageHashes;
    public static final String DUPLICATE_MSG = "DuplicateMsg";
    public static final String BROKEN_METADATA = "BrokenMetaData";
    public static final String BROKEN_MSG = "BrokenMsg";
    public static final String MSG_NOT_FOR_ME = "NotForMe";
    public static final String DECRYPT_FAILED = "DecryptFailed";
    public static final String INVALID_MSG = "InvalidMsg";

    public int getThreadType() {
        if (this.flagNew) {
            return 1;
        }
        return 2;
    }

    public void run() {
        this.notifyThreadStarted(this);
        try {
            String string = this.flagNew ? "TOF Download" : "TOF Download Back";
            int n = (int)(Math.random() * 5000.0);
            Mixed.wait(n);
            logger.info("TOFDN: " + string + " Thread started for board " + this.board.getName());
            if (this.isInterrupted()) {
                this.notifyThreadFinished(this);
                return;
            }
            if (!this.board.isPublicBoard()) {
                this.publicKey = this.board.getPublicKey();
                this.secure = true;
            } else {
                this.secure = false;
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            if (this.flagNew) {
                this.downloadDate(gregorianCalendar);
            } else {
                GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
                gregorianCalendar2.setTimeZone(TimeZone.getTimeZone("GMT"));
                gregorianCalendar2.set(1, 2001);
                gregorianCalendar2.set(2, 5);
                gregorianCalendar2.set(5, 11);
                for (int i = 0; !this.isInterrupted() && gregorianCalendar.after(gregorianCalendar2) && i < this.maxMessageDownload; ++i) {
                    gregorianCalendar.add(5, -1);
                    this.downloadDate(gregorianCalendar);
                }
            }
            logger.info("TOFDN: " + string + " Thread stopped for board " + this.board.getName());
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, Thread.currentThread().getName() + ": Oo. Exception in MessageDownloadThread:", throwable);
        }
        this.notifyThreadFinished(this);
    }

    protected void downloadDate(GregorianCalendar gregorianCalendar) {
        VerifyableMessageObject verifyableMessageObject = null;
        String string = DateFun.getDateOfCalendar(gregorianCalendar);
        String string2 = System.getProperty("file.separator");
        this.destination = new StringBuffer().append(this.keypool).append(this.board.getBoardFilename()).append(string2).append(string).append(string2).toString();
        File file = new File(this.destination);
        if (!file.exists()) {
            file.mkdirs();
        }
        File file2 = new File(this.destination + "locked.lck");
        int n = 0;
        int n2 = 0;
        int n3 = this.flagNew ? 3 : 2;
        while (n2 < n3 && (this.flagNew || !file2.exists())) {
            Object object;
            Object object2;
            String string3;
            if (this.isInterrupted()) {
                return;
            }
            File file3 = null;
            File file4 = null;
            byte[] byArray = null;
            try {
                boolean bl;
                string3 = new StringBuffer().append(this.destination).append(System.currentTimeMillis()).append(".xml.msg").toString();
                file3 = new File(string3);
                string3 = new StringBuffer().append(this.destination).append(string).append("-").append(this.board.getBoardFilename()).append("-").append(n).append(".xml").toString();
                file4 = new File(string3);
                if (file4.length() > 0L) {
                    ++n;
                    n2 = 0;
                    continue;
                }
                object2 = null;
                object2 = this.secure ? new StringBuffer().append(this.publicKey).append("/").append(this.board.getBoardFilename()).append("/").append(string).append("-").append(n).append(".xml").toString() : new StringBuffer().append("KSK@frost/message/").append(MainFrame.frostSettings.getValue("messageBase")).append("/").append(string).append("-").append(this.board.getBoardFilename()).append("-").append(n).append(".xml").toString();
                object = FcpRequest.getFile((String)object2, null, file3, this.downloadHtl, false, bl = !this.flagNew);
                byArray = object == null ? null : ((FcpResults)object).getRawMetadata();
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "TOFDN: Exception thrown in downloadDate(GregorianCalendar calDL)", throwable);
                file3.delete();
            }
            Mixed.wait(111);
            ++n;
            try {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                if (file3.length() == 0L) {
                    ++n2;
                    continue;
                }
                n2 = 0;
                file3.renameTo(file4);
                file3 = file4;
                string3 = Core.getCrypto().digest(file3);
                if (this.messageHashes.contains(string3)) {
                    logger.info(Thread.currentThread().getName() + ": TOFDN: ****** Duplicate Message : " + file3.getName() + " *****");
                    FileAccess.writeFile(DUPLICATE_MSG, file3);
                    continue;
                }
                this.messageHashes.add(string3);
                if (byArray == null) {
                    object2 = FileAccess.readZipFileBinary(file3);
                    if (object2 == null) {
                        logger.log(Level.SEVERE, "TOFDN: Unzip of unsigned xml failed");
                        FileAccess.writeFile(BROKEN_MSG, file3);
                        continue;
                    }
                    FileAccess.writeFile(object2, file3);
                    try {
                        verifyableMessageObject = new VerifyableMessageObject(file3);
                        this.addMessageToGui(verifyableMessageObject, file3, true, gregorianCalendar, 2);
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, "TOFDN: Exception thrown in downloadDate(GregorianCalendar calDL)", exception);
                        FileAccess.writeFile(BROKEN_MSG, file3);
                    }
                    continue;
                }
                object2 = null;
                try {
                    object6 = XMLTools.parseXmlContent(byArray, false).getDocumentElement();
                    object2 = MetaData.getInstance((Element)object6);
                }
                catch (Throwable throwable) {
                    logger.log(Level.SEVERE, "TOFDN: Exeption in MetaData.getInstance(): ", throwable);
                    object2 = null;
                }
                if (object2 == null) {
                    logger.log(Level.SEVERE, "TOFDN: Metadata couldn't be read. Offending file saved as badmetadata.xml - send to a dev for analysis");
                    object6 = new File("badmetadata.xml");
                    FileAccess.writeFile(byArray, (File)object6);
                    FileAccess.writeFile(BROKEN_METADATA, file3);
                    continue;
                }
                assert (object2.getType() == 0 || object2.getType() == 1) : "TOFDN: unknown type of metadata";
                object6 = (SignMetaData)object2;
                object = ((MetaData)object6).getPerson().getUniqueName();
                Identity identity = this.identities.getIdentity((String)object);
                if (identity == null) {
                    identity = ((MetaData)object6).getPerson();
                    identity.setState(2);
                    this.identities.addIdentity(identity);
                }
                byte[] byArray2 = FileAccess.readByteArray(file3);
                boolean bl = Core.getCrypto().detachedVerify(byArray2, identity.getKey(), ((SignMetaData)object6).getSig());
                if (bl) {
                    identity.updateLastSeenTimestamp();
                }
                if (object2.getType() == 1) {
                    object5 = (EncryptMetaData)object6;
                    if (!((EncryptMetaData)object5).getRecipient().equals(this.identities.getMyId().getUniqueName())) {
                        logger.fine("TOFDN: Encrypted message was not for me.");
                        FileAccess.writeFile(MSG_NOT_FOR_ME, file3);
                        continue;
                    }
                    object4 = FileAccess.readByteArray(file3);
                    object3 = Core.getCrypto().decrypt((byte[])object4, this.identities.getMyId().getPrivKey());
                    if (object3 == null) {
                        logger.log(Level.SEVERE, "TOFDN: Encrypted message from " + ((MetaData)object5).getPerson().getUniqueName() + " could not be decrypted!");
                        FileAccess.writeFile(DECRYPT_FAILED, file3);
                        continue;
                    }
                    file3.delete();
                    FileAccess.writeFile(object3, file3);
                    logger.fine("TOFDN: Decrypted an encrypted message for me, sender was " + ((MetaData)object5).getPerson().getUniqueName());
                }
                if ((object5 = (Object)FileAccess.readZipFileBinary(file3)) == null) {
                    logger.log(Level.SEVERE, "TOFDN: Unzip of signed xml failed");
                    FileAccess.writeFile(BROKEN_MSG, file3);
                    continue;
                }
                FileAccess.writeFile((byte[])object5, file3);
                try {
                    verifyableMessageObject = new VerifyableMessageObject(file3);
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "TOFDN: Exception when creating message object", exception);
                    FileAccess.writeFile(BROKEN_MSG, file3);
                    continue;
                }
                if (!bl) {
                    logger.warning("TOFDN: message failed verification, status set to TAMPERED.");
                    this.addMessageToGui(verifyableMessageObject, file3, false, gregorianCalendar, 1);
                    continue;
                }
                object4 = Mixed.makeFilename(Core.getCrypto().digest(((MetaData)object6).getPerson().getKey()));
                if (!((String)object4).equals(object3 = (Object)Mixed.makeFilename(verifyableMessageObject.getFrom().substring(verifyableMessageObject.getFrom().indexOf("@") + 1, verifyableMessageObject.getFrom().length())))) {
                    logger.warning("TOFDN: Hash in metadata doesn't match hash in message!\nmetadata : " + (String)object4 + " , message: " + (String)object3 + ". Message failed verification, status set to TAMPERED.");
                    this.addMessageToGui(verifyableMessageObject, file3, false, gregorianCalendar, 1);
                    continue;
                }
                this.addMessageToGui(verifyableMessageObject, file3, true, gregorianCalendar, 3);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "TOFDN: Exception thrown in downloadDate(GregorianCalendar calDL)", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessageToGui(VerifyableMessageObject verifyableMessageObject, File file, boolean bl, GregorianCalendar gregorianCalendar, int n) {
        if (verifyableMessageObject.isValid() && verifyableMessageObject.isValidFormat(gregorianCalendar)) {
            verifyableMessageObject.setSignatureStatus(n);
            if (!verifyableMessageObject.save()) {
                logger.log(Level.SEVERE, "TOFDN: Could not save the XML file after setting the signatureState! signatureState keeps UNSET.");
            }
            if (file.length() > 0L && TOF.getInstance().blocked(verifyableMessageObject, this.board)) {
                this.board.incBlocked();
                logger.info("TOFDN: Blocked message for board '" + this.board.getName() + "'");
            } else {
                GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
                gregorianCalendar2.setTimeZone(TimeZone.getTimeZone("GMT"));
                gregorianCalendar2.add(5, -1 * this.board.getMaxMessageDisplay());
                Calendar calendar = DateFun.getCalendarFromDate(verifyableMessageObject.getDate());
                if (!calendar.before(gregorianCalendar2)) {
                    TOF.getInstance().addNewMessageToTable(file, this.board, bl);
                } else {
                    logger.log(Level.SEVERE, "TOFDN: received message from the past, not displayed due to max message days to display:" + file.getPath());
                }
                Iterator iterator = verifyableMessageObject.getAttachmentsOfType(0).iterator();
                while (iterator.hasNext()) {
                    Index index;
                    SharedFileObject sharedFileObject = ((FileAttachment)iterator.next()).getFileObj();
                    if (sharedFileObject.getOwner() == null) continue;
                    Index index2 = index = Index.getInstance();
                    synchronized (index2) {
                        index.add(sharedFileObject, this.board);
                    }
                }
                Core.addNewKnownBoards(verifyableMessageObject.getAttachmentsOfType(1));
            }
        } else {
            FileAccess.writeFile(INVALID_MSG, file);
            logger.warning("TOFDN: Message " + file.getName() + " was dropped, format validation failed.");
        }
    }

    public MessageDownloadThread(boolean bl, Board board, int n, String string, String string2, FrostIdentities frostIdentities) {
        super(board, frostIdentities);
        this.flagNew = bl;
        this.board = board;
        this.downloadHtl = n;
        this.keypool = string;
        this.maxMessageDownload = Integer.parseInt(string2);
    }

    public void setMessageHashes(MessageHashes messageHashes) {
        this.messageHashes = messageHashes;
    }
}

