/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.Core;
import frost.DateFun;
import frost.MainFrame;
import frost.Mixed;
import frost.fcp.FcpRequest;
import frost.fileTransfer.Index;
import frost.identities.FrostIdentities;
import frost.identities.Identity;
import frost.messages.FrostIndex;
import frost.messages.SharedFileObject;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import java.util.logging.Logger;

public class GetFriendsRequestsThread
extends TimerTask {
    private FrostIdentities identities;
    private RequestThread runner = null;
    private static Logger logger = Logger.getLogger(GetFriendsRequestsThread.class.getName());

    public GetFriendsRequestsThread(FrostIdentities frostIdentities) {
        this.identities = frostIdentities;
    }

    public void run() {
        if (this.runner == null) {
            this.runner = new RequestThread();
            this.runner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set generatePrefixes() {
        HashSet hashSet = new HashSet();
        File file = new File(MainFrame.keypool);
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2;
            if (!fileArray[i].isDirectory() || !(file2 = new File(fileArray[i].getPath() + File.separator + "files.xml")).isFile()) continue;
            FrostIndex frostIndex = null;
            Index index = Index.getInstance();
            Object object = index;
            synchronized (object) {
                frostIndex = index.readKeyFile(file2);
            }
            if (frostIndex == null) continue;
            object = frostIndex.getFilesMap().values();
            this.addToPrefixes((Collection)object, hashSet);
        }
        fileArray = null;
        System.gc();
        return hashSet;
    }

    private void addToPrefixes(Collection collection, Set set) {
        for (SharedFileObject sharedFileObject : collection) {
            Identity identity;
            if (sharedFileObject.getOwner() == null || (identity = this.identities.getIdentity(sharedFileObject.getOwner())) == null || sharedFileObject.getOwner().compareTo(this.identities.getMyId().getUniqueName()) == 0 || identity.getState() != 1) continue;
            String string = new StringBuffer().append("KSK@frost/request/").append(Core.frostSettings.getValue("messageBase")).append("/").append(Mixed.makeFilename(sharedFileObject.getOwner())).append("-").append(sharedFileObject.getBatch()).toString();
            set.add(string);
        }
    }

    private void doRequests() {
        logger.info("starting to request requests for friends");
        Set set = this.generatePrefixes();
        logger.info("Will help a total of " + set.size() + " batches");
        File file = new File("requests" + File.separator + "helper.tmp");
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            iterator.remove();
            String string3 = DateFun.getDate();
            int n = -1;
            do {
                string = new StringBuffer().append(string2).append("-").append(string3).append("-").append(++n).append(".req.sha").toString();
                logger.fine("friend's request address is " + string);
                file.delete();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (FcpRequest.getFile(string, null, file, 21, true, false) != null);
            logger.fine("batch of " + string2 + " had " + n + " requests");
        }
        file.delete();
        logger.info("finishing requesting friend's requests");
    }

    private class RequestThread
    extends Thread {
        private RequestThread() {
        }

        public void run() {
            GetFriendsRequestsThread.this.doRequests();
            GetFriendsRequestsThread.this.runner = null;
        }
    }
}

