/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.gui.objects.Board;
import frost.identities.FrostIdentities;
import frost.threads.BoardUpdateThread;
import frost.threads.BoardUpdateThreadListener;
import java.util.Iterator;
import java.util.Vector;

public class BoardUpdateThreadObject
extends Thread {
    protected FrostIdentities identities;
    Board targetBoard = null;
    long startTimeMillis = -1L;
    boolean isFinished = false;
    Vector registeredListeners = null;

    public BoardUpdateThreadObject(Board board, FrostIdentities frostIdentities) {
        super(board.getName());
        this.targetBoard = board;
        this.registeredListeners = new Vector();
        this.identities = frostIdentities;
    }

    public Board getTargetBoard() {
        return this.targetBoard;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public synchronized boolean isFinished() {
        return this.isFinished;
    }

    protected synchronized void threadFinished() {
        this.isFinished = true;
    }

    protected void notifyThreadStarted(BoardUpdateThread boardUpdateThread) {
        this.startTimeMillis = System.currentTimeMillis();
        Iterator iterator = this.registeredListeners.iterator();
        while (iterator.hasNext()) {
            ((BoardUpdateThreadListener)iterator.next()).boardUpdateThreadStarted(boardUpdateThread);
        }
    }

    protected void notifyThreadFinished(BoardUpdateThread boardUpdateThread) {
        this.threadFinished();
        Iterator iterator = this.registeredListeners.iterator();
        while (iterator.hasNext()) {
            ((BoardUpdateThreadListener)iterator.next()).boardUpdateThreadFinished(boardUpdateThread);
        }
    }

    public void addBoardUpdateThreadListener(BoardUpdateThreadListener boardUpdateThreadListener) {
        this.registeredListeners.add(boardUpdateThreadListener);
    }

    public void removeBoardUpdateThreadListener(BoardUpdateThreadListener boardUpdateThreadListener) {
        this.registeredListeners.remove(boardUpdateThreadListener);
    }
}

