/*
 * Decompiled with CFR 0.152.
 */
package frost.storage;

import frost.SettingsClass;
import frost.events.FrostEventDispatcher;
import frost.events.StorageErrorEvent;
import frost.storage.Savable;
import frost.storage.StorageException;
import frost.util.gui.translation.Language;
import java.util.Enumeration;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StorageManager
extends Timer {
    private static Logger logger = Logger.getLogger(StorageManager.class.getName());
    private Language language;
    private FrostEventDispatcher listener;
    private ShutdownThread shutdownThread = new ShutdownThread();
    private AutoTask autoTask = new AutoTask();
    private Vector autoSavables;
    private Vector exitSavables;

    public StorageManager(SettingsClass settingsClass, FrostEventDispatcher frostEventDispatcher) {
        this.language = Language.getInstance();
        this.listener = frostEventDispatcher;
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        int n = settingsClass.getIntValue("autoSaveInterval");
        this.schedule((TimerTask)this.autoTask, n * 60 * 1000, (long)(n * 60 * 1000));
    }

    public synchronized void addAutoSavable(Savable savable) {
        if (savable == null) {
            return;
        }
        if (this.autoSavables == null) {
            this.autoSavables = new Vector();
        }
        this.autoSavables.addElement(savable);
    }

    public synchronized void addExitSavable(Savable savable) {
        if (savable == null) {
            return;
        }
        if (this.exitSavables == null) {
            this.exitSavables = new Vector();
        }
        this.exitSavables.addElement(savable);
    }

    private class ShutdownThread
    extends Thread {
        public void run() {
            logger.info("Saving settings ...");
            if (StorageManager.this.exitSavables != null) {
                Enumeration enumeration = StorageManager.this.exitSavables.elements();
                while (enumeration.hasMoreElements()) {
                    Savable savable = (Savable)enumeration.nextElement();
                    try {
                        savable.save();
                    }
                    catch (StorageException storageException) {
                        logger.log(Level.SEVERE, "Error while saving a resource inside the shutdown hook.", storageException);
                    }
                }
            }
            logger.info("Bye!");
        }
    }

    private class AutoTask
    extends TimerTask {
        public void run() {
            if (StorageManager.this.autoSavables != null) {
                Enumeration enumeration = StorageManager.this.autoSavables.elements();
                while (enumeration.hasMoreElements()) {
                    Savable savable = (Savable)enumeration.nextElement();
                    try {
                        savable.save();
                    }
                    catch (StorageException storageException) {
                        logger.log(Level.SEVERE, "Error while saving a resource inside the timer.", storageException);
                        StorageErrorEvent storageErrorEvent = new StorageErrorEvent(StorageManager.this.language.getString("Saver.AutoTask.message"));
                        storageErrorEvent.setException(storageException);
                        StorageManager.this.listener.dispatchEvent(storageErrorEvent);
                    }
                }
            }
        }
    }
}

