/*
 * Decompiled with CFR 0.152.
 */
package frost.storage;

import frost.SettingsClass;
import frost.fileTransfer.download.DownloadModelDAO;
import frost.fileTransfer.upload.UploadModelDAO;
import frost.identities.IdentitiesDAO;
import frost.messaging.MessageHashesDAO;
import frost.storage.HsqldbDAOFactory;
import frost.storage.XmlDAOFactory;

public abstract class DAOFactory {
    public static final int XML = 1;
    public static final int HSQLDB = 2;
    private static XmlDAOFactory xmlDAOFactory = null;
    private static HsqldbDAOFactory hsqldbDAOFactory = null;
    private static SettingsClass settings;

    public static DAOFactory getFactory(int n) {
        switch (n) {
            case 1: {
                return DAOFactory.getXmlDAOFactory();
            }
            case 2: {
                return DAOFactory.getHsqldbDAOFactory();
            }
        }
        return null;
    }

    private static HsqldbDAOFactory getHsqldbDAOFactory() {
        if (hsqldbDAOFactory == null) {
            hsqldbDAOFactory = new HsqldbDAOFactory(settings);
        }
        return hsqldbDAOFactory;
    }

    private static XmlDAOFactory getXmlDAOFactory() {
        if (xmlDAOFactory == null) {
            xmlDAOFactory = new XmlDAOFactory(settings);
        }
        return xmlDAOFactory;
    }

    public abstract IdentitiesDAO getIdentitiesDAO();

    public abstract DownloadModelDAO getDownloadModelDAO();

    public abstract UploadModelDAO getUploadModelDAO();

    public abstract MessageHashesDAO getMessageHashesDAO();

    public static void initialize(SettingsClass settingsClass) {
        settings = settingsClass;
    }
}

