/*
 * Decompiled with CFR 0.152.
 */
package frost.messaging;

import frost.FileAccess;
import frost.XMLTools;
import frost.messaging.MessageHashes;
import frost.messaging.MessageHashesDAO;
import frost.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MessageHashesXmlDAO
implements MessageHashesDAO {
    private static Logger logger = Logger.getLogger(MessageHashesXmlDAO.class.getName());
    private static final String XML_FILENAME = "hashes.xml";
    private static final String TMP_FILENAME = "hashes.xml.tmp";
    private static final String BAK_FILENAME = "hashes.xml.bak";

    public boolean exists() {
        File file = new File(XML_FILENAME);
        if (file.length() == 0L) {
            file.delete();
        }
        return file.isFile();
    }

    public void load(MessageHashes messageHashes) throws StorageException {
        if (!this.exists()) {
            return;
        }
        try {
            logger.info("Loading hashes.xml");
            Document document = XMLTools.parseXmlFile(XML_FILENAME, false);
            Element element = document.getDocumentElement();
            if (!element.getTagName().equals("MessageHashes")) {
                throw new StorageException("The message hashes XML file is invalid: does not contain the root tag MessageHashes.");
            }
            ArrayList arrayList = XMLTools.getChildElementsByTagName(element, "MessageHashesList");
            if (arrayList.size() != 1) {
                throw new StorageException("The message hashes XML file is invalid: MessageHashesList not found or duplicated.");
            }
            element = null;
            document = null;
            Element element2 = (Element)arrayList.get(0);
            if ((arrayList = XMLTools.getChildElementsByTagName(element2, "MessageHash")).size() == 0) {
                logger.info("The message hashes XML file has no hashes.");
            } else {
                for (int i = 0; i < arrayList.size(); ++i) {
                    Element element3 = (Element)arrayList.get(i);
                    String string = element3.getAttribute("value");
                    if (string == null || string.length() == 0) {
                        CDATASection cDATASection = (CDATASection)element3.getFirstChild();
                        if (cDATASection == null) {
                            logger.warning("No hash value found in MessageHash, continuing.");
                        }
                        string = cDATASection.getData().trim();
                    }
                    messageHashes.add(string);
                }
                logger.info("Loaded " + arrayList.size() + " hashes.");
            }
        }
        catch (Throwable throwable) {
            throw new StorageException("Exception while loading the new message hashes format. Starting empty hashes list.", throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(MessageHashes messageHashes) throws StorageException {
        Object object;
        Object object2;
        logger.info("Saving hashes.xml");
        File file = new File(XML_FILENAME);
        if (file.exists()) {
            object2 = new File(BAK_FILENAME);
            ((File)object2).delete();
            if (!FileAccess.copyFile(XML_FILENAME, BAK_FILENAME)) {
                logger.log(Level.SEVERE, "Error while copying hashes.xml to hashes.xml.bak");
            }
        }
        object2 = XMLTools.createDomDocument();
        Element element = object2.createElement("MessageHashes");
        object2.appendChild(element);
        Element element2 = object2.createElement("MessageHashesList");
        element.appendChild(element2);
        Iterator iterator = messageHashes.getHashes();
        while (iterator.hasNext()) {
            object = iterator.next().toString();
            Element element3 = object2.createElement("MessageHash");
            CDATASection cDATASection = object2.createCDATASection((String)object);
            element3.appendChild(cDATASection);
            element2.appendChild(element3);
        }
        object = new File(TMP_FILENAME);
        if (((File)object).isFile()) {
            ((File)object).delete();
        }
        if (!XMLTools.writeXmlFile((Document)object2, TMP_FILENAME)) throw new StorageException("Could not save hashes.xml");
        if (!((File)object).isFile()) throw new StorageException("Could not save hashes.xml");
        file.delete();
        if (((File)object).renameTo(file) || FileAccess.copyFile(BAK_FILENAME, XML_FILENAME)) return;
        throw new StorageException("Error while restoring hashes.xml");
    }

    public void create() throws StorageException {
        File file = new File(XML_FILENAME);
        try {
            boolean bl = file.createNewFile();
            if (!bl) {
                throw new StorageException("There was a problem while creating the storage.");
            }
        }
        catch (IOException iOException) {
            throw new StorageException("There was a problem while creating the storage.", iOException);
        }
    }
}

