/*
 * Decompiled with CFR 0.152.
 */
package frost.messaging;

import frost.messaging.MessageHashesDAO;
import frost.storage.DAOFactory;
import frost.storage.Savable;
import frost.storage.StorageException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class MessageHashes
implements Savable {
    private static final int MAX_HASHES = 3000;
    private final OwnLinkedHashMap hashesMap = new OwnLinkedHashMap();

    public void initialize() throws StorageException {
        MessageHashesDAO messageHashesDAO = DAOFactory.getFactory(1).getMessageHashesDAO();
        if (!messageHashesDAO.exists()) {
            messageHashesDAO.create();
        } else {
            messageHashesDAO.load(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws StorageException {
        MessageHashesDAO messageHashesDAO = DAOFactory.getFactory(1).getMessageHashesDAO();
        OwnLinkedHashMap ownLinkedHashMap = this.hashesMap;
        synchronized (ownLinkedHashMap) {
            messageHashesDAO.save(this);
        }
    }

    public synchronized void add(String string) {
        this.hashesMap.put(string, string);
    }

    public synchronized boolean contains(String string) {
        return this.hashesMap.containsKey(string);
    }

    protected Iterator getHashes() {
        return this.hashesMap.keySet().iterator();
    }

    private class OwnLinkedHashMap
    extends LinkedHashMap {
        public OwnLinkedHashMap() {
            super(3000);
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 3000;
        }
    }
}

