/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.Core;
import frost.identities.FrostIdentities;
import frost.identities.Identity;
import frost.messages.MessageCreationException;
import frost.messages.MessageObject;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VerifyableMessageObject
extends MessageObject
implements Cloneable {
    private static Logger logger = Logger.getLogger(VerifyableMessageObject.class.getName());
    public static final int xGOOD = 1;
    public static final int xCHECK = 2;
    public static final int xBAD = 3;
    public static final int xOBSERVE = 4;
    public static final int xTAMPERED = 5;
    public static final int xOLD = 6;
    private Identity fromIdentity = null;

    public Identity getFromIdentity() {
        if (this.fromIdentity == null) {
            FrostIdentities frostIdentities = Core.getInstance().getIdentities();
            this.fromIdentity = frostIdentities.isMySelf(this.getFrom()) ? frostIdentities.getMyId() : frostIdentities.getIdentity(this.getFrom());
        }
        return this.fromIdentity;
    }

    public int getMsgStatus() {
        if (this.getSignatureStatus() == 3) {
            if (this.getFromIdentity() == null) {
                logger.log(Level.SEVERE, "No identity for from found: " + this.getFrom());
                return 6;
            }
            int n = this.getFromIdentity().getState();
            if (n == 2) {
                return 2;
            }
            if (n == 3) {
                return 4;
            }
            if (n == 1) {
                return 1;
            }
            if (n == 4) {
                return 3;
            }
        } else {
            if (this.getSignatureStatus() == 2) {
                return 6;
            }
            if (this.getSignatureStatus() == 1) {
                return 5;
            }
        }
        return 6;
    }

    public String getMsgStatusString() {
        int n = this.getMsgStatus();
        if (n == 1) {
            return "GOOD";
        }
        if (n == 2) {
            return "CHECK";
        }
        if (n == 3) {
            return "BAD";
        }
        if (n == 4) {
            return "OBSERVE";
        }
        if (n == 6) {
            return "NONE";
        }
        if (n == 5) {
            return "FAKE";
        }
        return "*err*";
    }

    public VerifyableMessageObject copy() throws CloneNotSupportedException {
        return (VerifyableMessageObject)this.clone();
    }

    public VerifyableMessageObject(File file) throws MessageCreationException {
        super(file);
    }

    public boolean isValidFormat(GregorianCalendar gregorianCalendar) {
        try {
            if (!this.verifyDate(gregorianCalendar) || !this.verifyTime()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.SEVERE, "Exception in isValidFormat() - skipping Message.", throwable);
            return false;
        }
        return true;
    }

    public boolean verifyDate(GregorianCalendar gregorianCalendar) {
        VerifyableMessageObject verifyableMessageObject = this;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd");
        String string = verifyableMessageObject.getDate();
        Date date = null;
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (date == null) {
            logger.warning("* verifyDate(): Invalid date string found, will block message: " + string);
            return false;
        }
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime(date);
        gregorianCalendar2.set(11, 1);
        gregorianCalendar2.set(12, 0);
        gregorianCalendar2.set(13, 0);
        gregorianCalendar2.set(14, 0);
        gregorianCalendar.set(11, 1);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        gregorianCalendar.set(14, 0);
        long l = gregorianCalendar.getTimeInMillis();
        long l2 = gregorianCalendar2.getTimeInMillis();
        long l3 = 86400000L;
        int n = (int)((l - l2) / l3);
        if (Math.abs(n) > 1) {
            if (n < 0) {
                logger.warning("* verifyDate(): Date in message is later than date in URL, will block message: " + string);
                return false;
            }
            if (n > 1) {
                logger.warning("* verifyDate(): Date in message is earlier than date in URL, will block message: " + string);
                return false;
            }
        }
        return true;
    }

    public boolean verifyTime() {
        VerifyableMessageObject verifyableMessageObject = this;
        String string = verifyableMessageObject.getTime();
        if (string == null) {
            logger.warning("* verifyTime(): Time is NULL, blocking message.");
            return false;
        }
        if ((string = string.trim()).length() != 11) {
            logger.warning("* verifyTime(): Time string have invalid length (!=11), blocking message: " + string);
            return false;
        }
        if (!(Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(1)) && string.charAt(2) == ':' && Character.isDigit(string.charAt(3)) && Character.isDigit(string.charAt(4)) && string.charAt(5) == ':' && Character.isDigit(string.charAt(6)) && Character.isDigit(string.charAt(7)) && string.charAt(8) == 'G' && string.charAt(9) == 'M' && string.charAt(10) == 'T')) {
            logger.warning("* verifyTime(): Time string have invalid format (xx:xx:xxGMT), blocking message: " + string);
            return false;
        }
        String string2 = string.substring(0, 2);
        String string3 = string.substring(3, 5);
        String string4 = string.substring(6, 8);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        try {
            n = Integer.parseInt(string2);
            n2 = Integer.parseInt(string3);
            n3 = Integer.parseInt(string4);
        }
        catch (Exception exception) {
            logger.warning("* verifyTime(): Could not parse the numbers, blocking message: " + string);
            return false;
        }
        if (n < 0 || n > 23 || n2 < 0 || n2 > 59 || n3 < 0 || n3 > 59) {
            logger.warning("* verifyTime(): Time is invalid, blocking message: " + string);
            return false;
        }
        return true;
    }
}

