/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.Core;
import frost.DateFun;
import frost.MainFrame;
import frost.XMLTools;
import frost.XMLizable;
import frost.gui.objects.Board;
import frost.messages.RedirectFileObject;
import java.io.File;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class SharedFileObject
implements XMLizable {
    private static Logger logger = Logger.getLogger(SharedFileObject.class.getName());
    private boolean DEBUG = false;
    private static final String[] invalidChars = new String[]{"/", "\\", "?", "*", "<", ">", "\"", ":", "|"};
    String key = null;
    String date = null;
    String lastSharedDate = null;
    String SHA1 = null;
    String owner = null;
    Long size = new Long(0L);
    String filename = new String();
    File file = null;
    String batch = null;
    Board board;
    boolean exchange;

    public GregorianCalendar getCal() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        int n = this.date.indexOf(".");
        int n2 = this.date.lastIndexOf(".");
        if (n != -1 && n2 != -1 && n != n2) {
            int n3 = Integer.parseInt(this.date.substring(0, n));
            int n4 = Integer.parseInt(this.date.substring(n + 1, n2));
            int n5 = Integer.parseInt(this.date.substring(n2 + 1, this.date.length()));
            gregorianCalendar.set(1, n3);
            gregorianCalendar.set(2, n4 - 1);
            gregorianCalendar.set(5, n5 - 1);
        }
        return gregorianCalendar;
    }

    public boolean checkDate() {
        if (this.date == null) {
            return true;
        }
        int n = MainFrame.frostSettings.getIntValue("maxAge");
        String string = DateFun.getDate(n);
        Calendar calendar = null;
        Calendar calendar2 = null;
        Calendar calendar3 = DateFun.getCalendarFromDate(DateFun.getDate());
        try {
            calendar = DateFun.getCalendarFromDate(this.date);
            calendar2 = DateFun.getCalendarFromDate(string);
        }
        catch (NumberFormatException numberFormatException) {
            logger.warning("file " + this.filename + " has invalid date: " + this.date);
            return false;
        }
        if (calendar2.after(calendar)) {
            logger.warning(this.filename + " is outdated");
            return false;
        }
        calendar3.add(5, 2);
        if (calendar.after(calendar3)) {
            logger.warning("Future date of " + this.filename + " " + this.date);
            return false;
        }
        return true;
    }

    public boolean checkFilename() {
        if (this.filename == null || this.filename.length() == 0 || this.filename.length() > 255) {
            return false;
        }
        for (int i = 0; i < invalidChars.length; ++i) {
            if (this.filename.indexOf(invalidChars[i]) == -1) continue;
            return false;
        }
        return true;
    }

    public boolean checkSize() {
        return this.size != null;
    }

    public boolean checkKey() {
        if (this.key == null) {
            return true;
        }
        return this.key.startsWith("CHK@") && this.key.length() == 58;
    }

    public boolean isValid() {
        boolean bl = true;
        bl = bl && this.checkSize();
        bl = bl && this.checkFilename();
        bl = bl && this.checkKey();
        return bl;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename.trim();
    }

    public String getSHA1() {
        return this.SHA1;
    }

    public void setSHA1(String string) {
        this.SHA1 = string;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public String getKey() {
        if (this.key == null) {
            return this.key;
        }
        return this.key.trim();
    }

    public void setDate(String string) {
        this.date = string;
    }

    public String getDate() {
        if (this.date == null) {
            return this.date;
        }
        return this.date.trim();
    }

    public void setSize(String string) {
        try {
            this.size = new Long(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.size = null;
        }
    }

    public void setSize(long l) {
        this.size = new Long(l);
    }

    public Long getSize() {
        return this.size;
    }

    public boolean getExchange() {
        return this.exchange;
    }

    public void setExchange(boolean bl) {
        this.exchange = bl;
    }

    public String getLastSharedDate() {
        return this.lastSharedDate;
    }

    public void setLastSharedDate(String string) {
        this.lastSharedDate = string;
    }

    public String getBatch() {
        return this.batch;
    }

    public void setBatch(String string) {
        this.batch = string;
    }

    public SharedFileObject(String string) {
        this.key = string;
        this.exchange = true;
    }

    public SharedFileObject() {
        this.exchange = true;
    }

    public SharedFileObject(File file, Board board) {
        this.SHA1 = Core.getCrypto().digest(file);
        this.size = new Long(file.length());
        this.filename = file.getName();
        this.date = DateFun.getDate();
        this.file = file;
        this.key = null;
        this.board = board;
        if (board == null) {
            this.batch = null;
        } else {
            for (String string : Core.getMyBatches().entrySet()) {
                int n = (Integer)Core.getMyBatches().get(string);
                if (n >= Core.frostSettings.getIntValue("batchSize")) continue;
                this.batch = string;
                break;
            }
        }
    }

    public Element getXMLElement(Document document) {
        Element element = document.createElement("File");
        Element element2 = document.createElement("name");
        CDATASection cDATASection = document.createCDATASection(this.getFilename());
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        element2 = document.createElement("SHA1");
        cDATASection = document.createCDATASection(this.getSHA1());
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        element2 = document.createElement("size");
        Text text = document.createTextNode("" + this.getSize());
        element2.appendChild(text);
        element.appendChild(element2);
        if (this.getBatch() != null) {
            element2 = document.createElement("batch");
            text = document.createTextNode(this.getBatch());
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if (this.getOwner() != null) {
            element2 = document.createElement("owner");
            cDATASection = document.createCDATASection(this.getOwner());
            element2.appendChild(cDATASection);
            element.appendChild(element2);
        }
        if (this.getKey() != null) {
            element2 = document.createElement("key");
            text = document.createTextNode(this.getKey());
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if (this.getDate() != null) {
            element2 = document.createElement("date");
            text = document.createTextNode(this.getDate());
            element2.appendChild(text);
            element.appendChild(element2);
        }
        if (this.getLastSharedDate() != null) {
            element2 = document.createElement("dateShared");
            text = document.createTextNode(this.getLastSharedDate());
            element2.appendChild(text);
            element.appendChild(element2);
        }
        return element;
    }

    public void loadXMLElement(Element element) throws SAXException {
        this.setFilename(XMLTools.getChildElementsCDATAValue(element, "name"));
        this.setSHA1(XMLTools.getChildElementsCDATAValue(element, "SHA1"));
        this.setOwner(XMLTools.getChildElementsCDATAValue(element, "owner"));
        this.setKey(XMLTools.getChildElementsTextValue(element, "key"));
        this.setDate(XMLTools.getChildElementsTextValue(element, "date"));
        this.setLastSharedDate(XMLTools.getChildElementsTextValue(element, "dateShared"));
        this.setSize(XMLTools.getChildElementsTextValue(element, "size"));
        this.setBatch(XMLTools.getChildElementsTextValue(element, "batch"));
        assert (this.filename != null);
        assert (this.size != null);
    }

    public Board getBoard() {
        return this.board;
    }

    public boolean isOnline() {
        if (this.date == null) {
            return false;
        }
        if (this.key == null) {
            return false;
        }
        return this.checkDate();
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setBoard(Board board) {
        this.board = board;
    }

    public boolean equals(Object object) {
        SharedFileObject sharedFileObject = (SharedFileObject)object;
        return this.SHA1.equals(sharedFileObject.getSHA1());
    }

    public int hashCode() {
        return this.SHA1.hashCode();
    }

    public static SharedFileObject getInstance(Element element) {
        try {
            if (element.getAttribute("redirect").length() > 0) {
                return RedirectFileObject.getRedirectInstance(element);
            }
            SharedFileObject sharedFileObject = new SharedFileObject();
            sharedFileObject.loadXMLElement(element);
            return sharedFileObject;
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, "parsing file failed.", sAXException);
            return null;
        }
    }
}

