/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.FileAccess;
import frost.Mixed;
import frost.XMLTools;
import frost.XMLizable;
import frost.messages.Attachment;
import frost.messages.AttachmentList;
import frost.messages.FileAttachment;
import frost.messages.MessageCreationException;
import frost.messages.SharedFileObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MessageObject
implements XMLizable {
    private static Logger logger = Logger.getLogger(MessageObject.class.getName());
    private static final char[] evilChars = new char[]{'/', '\\', '*', '=', '|', '&', '#', '\"', '<', '>'};
    public static final String NEW_MSG_INDICATOR_STR = "NewMessage";
    public static final int SIGNATURESTATUS_UNSET = 0;
    public static final int SIGNATURESTATUS_TAMPERED = 1;
    public static final int SIGNATURESTATUS_OLD = 2;
    public static final int SIGNATURESTATUS_VERIFIED = 3;
    private static final String SIGNATURESTATUS_TAMPERED_STR = "TAMPERED";
    private static final String SIGNATURESTATUS_OLD_STR = "OLD";
    private static final String SIGNATURESTATUS_VERIFIED_STR = "VERIFIED";
    private AttachmentList attachments;
    private String board = "";
    private String content = "";
    private String from = "";
    private String subject = "";
    private String date = "";
    private String time = "";
    private String index = "";
    private String publicKey = "";
    private String recipient = "";
    private boolean deleted = false;
    private int signatureStatus = 0;
    protected File file;
    private Boolean messageIsNew = null;

    public MessageObject() {
    }

    public MessageObject(File file) throws MessageCreationException {
        this();
        if (file == null) {
            throw new MessageCreationException("Invalid input file for MessageObject. Its value is null.");
        }
        if (!file.exists()) {
            throw new MessageCreationException("Invalid input file '" + file.getName() + "' for MessageObject. It doesn't exist.");
        }
        if (file.length() < 20L) {
            throw new MessageCreationException("Info only: Empty input file '" + file.getName() + "' for MessageObject (size < 20).", true);
        }
        this.file = file;
        try {
            this.loadFile();
            this.analyzeFile();
        }
        catch (Exception exception) {
            throw new MessageCreationException("Invalid input file '" + file.getName() + "' for MessageObject (load/analyze failed).", exception);
        }
    }

    public void analyzeFile() throws Exception {
        String string = this.file.getName();
        this.index = string.substring(string.lastIndexOf("-") + 1, string.lastIndexOf(".xml")).trim();
        if (this.from == null || this.date == null || this.time == null || this.board == null || !this.isValid()) {
            String string2 = "Analyze file failed.  File saved as \"badMessage\", send to a dev.  Reason:\n";
            if (!this.isValid()) {
                string2 = string2 + "isValid failed";
            }
            if (this.content == null) {
                string2 = string2 + "content null";
            }
            logger.severe(string2);
            this.file.renameTo(new File("badMessage"));
            throw new Exception("Message have invalid or missing fields.");
        }
        for (int i = 0; i < evilChars.length; ++i) {
            this.from = this.from.replace(evilChars[i], '_');
            this.subject = this.subject.replace(evilChars[i], '_');
            this.date = this.date.replace(evilChars[i], '_');
            this.time = this.time.replace(evilChars[i], '_');
        }
    }

    private AttachmentList getAttachmentList() {
        if (this.attachments == null) {
            this.attachments = new AttachmentList();
        }
        return this.attachments;
    }

    public AttachmentList getAttachmentsOfType(int n) {
        if (this.attachments == null) {
            return new AttachmentList();
        }
        return this.attachments.getAllOfType(n);
    }

    public AttachmentList getAllAttachments() {
        if (this.attachments == null) {
            return new AttachmentList();
        }
        return this.attachments;
    }

    public String getBoard() {
        return this.board;
    }

    public String getContent() {
        return this.content;
    }

    public String getDate() {
        return this.date;
    }

    public File getFile() {
        return this.file;
    }

    public String getFrom() {
        return this.from;
    }

    public String getIndex() {
        return this.index;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public List getOfflineFiles() {
        LinkedList<SharedFileObject> linkedList = new LinkedList<SharedFileObject>();
        if (this.attachments != null) {
            AttachmentList attachmentList = this.attachments.getAllOfType(0);
            Iterator iterator = attachmentList.iterator();
            while (iterator.hasNext()) {
                SharedFileObject sharedFileObject = ((FileAttachment)iterator.next()).getFileObj();
                if (sharedFileObject.isOnline()) continue;
                linkedList.add(sharedFileObject);
            }
        }
        return linkedList;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTime() {
        return this.time;
    }

    public Element getXMLElement(Document document) {
        Element element = document.createElement("FrostMessage");
        Element element2 = document.createElement("From");
        CDATASection cDATASection = document.createCDATASection(Mixed.makeSafeXML(this.getFrom()));
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        element2 = document.createElement("Subject");
        cDATASection = document.createCDATASection(Mixed.makeSafeXML(this.getSubject()));
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        element2 = document.createElement("Date");
        cDATASection = document.createCDATASection(Mixed.makeSafeXML(this.getDate()));
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        element2 = document.createElement("Time");
        cDATASection = document.createCDATASection(Mixed.makeSafeXML(this.getTime()));
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        element2 = document.createElement("Body");
        cDATASection = document.createCDATASection(Mixed.makeSafeXML(this.getContent()));
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        element2 = document.createElement("Board");
        cDATASection = document.createCDATASection(Mixed.makeSafeXML(this.getBoard()));
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        if (this.publicKey != null && this.publicKey.length() > 0) {
            element2 = document.createElement("pubKey");
            cDATASection = document.createCDATASection(Mixed.makeSafeXML(this.getPublicKey()));
            element2.appendChild(cDATASection);
            element.appendChild(element2);
        }
        if (this.recipient != null && this.recipient.length() > 0) {
            element2 = document.createElement("recipient");
            cDATASection = document.createCDATASection(Mixed.makeSafeXML(this.getRecipient()));
            element2.appendChild(cDATASection);
            element.appendChild(element2);
        }
        if (this.deleted) {
            element2 = document.createElement("Deleted");
            element.appendChild(element2);
        }
        if (this.signatureStatus != 0) {
            element2 = document.createElement("signatureStatus");
            if (this.signatureStatus == 1) {
                cDATASection = document.createCDATASection(SIGNATURESTATUS_TAMPERED_STR);
            } else if (this.signatureStatus == 2) {
                cDATASection = document.createCDATASection(SIGNATURESTATUS_OLD_STR);
            } else if (this.signatureStatus == 3) {
                cDATASection = document.createCDATASection(SIGNATURESTATUS_VERIFIED_STR);
            }
            element2.appendChild(cDATASection);
            element.appendChild(element2);
        }
        if (this.attachments != null && this.attachments.size() > 0) {
            element.appendChild(this.attachments.getXMLElement(document));
        }
        return element;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isValid() {
        if (this.date == null || this.date.length() == 0 || this.date.length() > 22) {
            return false;
        }
        if (this.time == null || this.time.length() == 0) {
            return false;
        }
        if (this.board == null || this.board.length() == 0 || this.board.length() > 256) {
            return false;
        }
        if (this.from == null || this.from.length() == 0 || this.from.length() > 256) {
            return false;
        }
        if (this.subject == null) {
            this.subject = "";
        } else if (this.subject.length() > 256) {
            return false;
        }
        if (this.content == null) {
            this.content = "";
        } else if (this.content.length() > 65536) {
            return false;
        }
        return true;
    }

    protected void loadFile() throws Exception {
        File file;
        Document document;
        block5: {
            document = null;
            try {
                document = XMLTools.parseXmlFile(this.file, false);
            }
            catch (Exception exception) {
                file = new File("badmessage.xml");
                if (!this.file.renameTo(file)) break block5;
                logger.log(Level.SEVERE, "Error - send the file badmessage.xml to a dev for analysis, more details below:", exception);
            }
        }
        if (document == null) {
            throw new Exception("Error - MessageObject.loadFile: couldn't parse XML Document - File name: '" + this.file.getName() + "'");
        }
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals("FrostMessage")) {
            file = new File("badmessage.xml");
            if (this.file.renameTo(file)) {
                logger.severe("Error - send the file badmessage.xml to a dev for analysis.");
            }
            throw new Exception("Error - invalid message: does not contain the root tag 'FrostMessage'");
        }
        this.loadXMLElement(element);
    }

    public void loadXMLElement(Element element) throws SAXException {
        ArrayList arrayList;
        this.from = XMLTools.getChildElementsCDATAValue(element, "From");
        this.date = XMLTools.getChildElementsCDATAValue(element, "Date");
        this.subject = XMLTools.getChildElementsCDATAValue(element, "Subject");
        this.time = XMLTools.getChildElementsCDATAValue(element, "Time");
        this.publicKey = XMLTools.getChildElementsCDATAValue(element, "pubKey");
        this.recipient = XMLTools.getChildElementsCDATAValue(element, "recipient");
        this.board = XMLTools.getChildElementsCDATAValue(element, "Board");
        this.content = XMLTools.getChildElementsCDATAValue(element, "Body");
        this.deleted = !XMLTools.getChildElementsByTagName(element, "Deleted").isEmpty();
        String string = XMLTools.getChildElementsCDATAValue(element, "signatureStatus");
        this.signatureStatus = 0;
        if (string != null && (string = string.trim()).length() > 0) {
            if (string.equalsIgnoreCase(SIGNATURESTATUS_TAMPERED_STR)) {
                this.signatureStatus = 1;
            } else if (string.equalsIgnoreCase(SIGNATURESTATUS_OLD_STR)) {
                this.signatureStatus = 2;
            } else if (string.equalsIgnoreCase(SIGNATURESTATUS_VERIFIED_STR)) {
                this.signatureStatus = 3;
            }
        }
        if ((arrayList = XMLTools.getChildElementsByTagName(element, "AttachmentList")).size() > 0) {
            Element element2 = (Element)arrayList.get(0);
            this.attachments = new AttachmentList();
            this.attachments.loadXMLElement(element2);
        }
    }

    public boolean save() {
        if (this.file == null) {
            logger.log(Level.SEVERE, "Error: internal File pointer is not set");
            return false;
        }
        return this.saveToFile(this.file);
    }

    public boolean saveToFile(File file) {
        File file2 = new File(file.getPath() + ".tmp");
        boolean bl = false;
        try {
            Document document = XMLTools.createDomDocument();
            document.appendChild(this.getXMLElement(document));
            bl = XMLTools.writeXmlFile(document, file2.getPath());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Error while saving message.", exception);
        }
        if (bl && file2.length() > 0L) {
            if (!file.delete()) {
                logger.log(Level.SEVERE, "Error while saving message, delete failed.");
            }
            if (!file2.renameTo(file)) {
                logger.log(Level.SEVERE, "Error while saving message, renameTo failed.");
                return false;
            }
        } else {
            file2.delete();
        }
        return bl;
    }

    public void setBoard(String string) {
        this.board = string;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public void setDate(String string) {
        this.date = string;
    }

    public void setDeleted(boolean bl) {
        this.deleted = bl;
        if (bl) {
            this.setMessageNew(false);
        }
    }

    public void setFrom(String string) {
        this.from = string;
    }

    public void setIndex(String string) {
        this.index = string;
    }

    public void setPublicKey(String string) {
        this.publicKey = string;
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    public void setTime(String string) {
        this.time = string;
    }

    public void setRecipient(String string) {
        this.recipient = string;
    }

    public void addAttachment(Attachment attachment) {
        this.getAttachmentList().add(attachment);
    }

    public int getSignatureStatus() {
        return this.signatureStatus;
    }

    public void setSignatureStatus(int n) {
        this.signatureStatus = n;
    }

    public boolean isMessageNew() {
        if (this.messageIsNew == null) {
            File file = new File(this.getFile().getPath() + ".lck");
            if (file.isFile()) {
                this.messageIsNew = new Boolean(true);
                return true;
            }
            this.messageIsNew = new Boolean(false);
            return false;
        }
        return this.messageIsNew;
    }

    public void setMessageNew(boolean bl) {
        final String string = this.getFile().getPath() + ".lck";
        Runnable runnable = null;
        if (bl) {
            this.messageIsNew = new Boolean(true);
            runnable = new Runnable(){

                public void run() {
                    FileAccess.writeFile(MessageObject.NEW_MSG_INDICATOR_STR, string);
                }
            };
        } else {
            this.messageIsNew = new Boolean(false);
            runnable = new Runnable(){

                public void run() {
                    new File(string).delete();
                }
            };
        }
        new Thread(runnable).start();
    }
}

