/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.Core;
import frost.XMLTools;
import frost.XMLizable;
import frost.identities.Identity;
import frost.messages.SharedFileObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FrostIndex
implements XMLizable {
    Identity sharer;
    Map filesMap;
    private static Logger logger = Logger.getLogger(FrostIndex.class.getName());

    public Element getXMLElement(Document document) {
        Element element = document.createElement("FrostIndex");
        if (Core.frostSettings.getBoolValue("signUploads") && this.sharer != null) {
            Element element2 = this.sharer.getSafeXMLElement(document);
            element.appendChild(element2);
        }
        boolean bl = Core.frostSettings.getBoolValue("signUploads");
        for (SharedFileObject sharedFileObject : this.getFilesMap().values()) {
            Element element3 = sharedFileObject.getXMLElement(document);
            ArrayList arrayList = XMLTools.getChildElementsByTagName(element3, "lastSharedDate");
            if (!bl) {
                arrayList.addAll(XMLTools.getChildElementsByTagName(element3, "owner"));
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                element3.removeChild((Element)iterator.next());
            }
            element.appendChild(element3);
        }
        return element;
    }

    public void loadXMLElement(Element element) throws SAXException {
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, "MyIdentity");
        this.sharer = arrayList.size() > 0 ? new Identity((Element)arrayList.get(0)) : null;
        ArrayList arrayList2 = XMLTools.getChildElementsByTagName(element, "File");
        this.filesMap = new HashMap();
        for (Element element2 : arrayList2) {
            SharedFileObject sharedFileObject = SharedFileObject.getInstance(element2);
            if (sharedFileObject.getSHA1() == null) continue;
            this.filesMap.put(sharedFileObject.getSHA1(), sharedFileObject);
        }
    }

    public FrostIndex(Element element) {
        try {
            this.loadXMLElement(element);
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", sAXException);
        }
    }

    public FrostIndex(Map map) {
        this.filesMap = map;
        this.sharer = Core.frostSettings.getBoolValue("signUploads") ? Core.getInstance().getIdentities().getMyId() : null;
    }

    public Identity getSharer() {
        return this.sharer;
    }

    public Map getFilesMap() {
        return this.filesMap;
    }
}

