/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.XMLTools;
import frost.messages.Attachment;
import frost.messages.SharedFileObject;
import java.io.File;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class FileAttachment
extends Attachment {
    private SharedFileObject fileObj;

    public int getType() {
        return 0;
    }

    public Element getXMLElement(Document document) {
        Element element = document.createElement("Attachment");
        element.setAttribute("type", "file");
        element.appendChild(this.fileObj.getXMLElement(document));
        if (!this.fileObj.isOnline() && this.fileObj.getFile() != null) {
            CDATASection cDATASection = document.createCDATASection(this.fileObj.getFile().getPath());
            Element element2 = document.createElement("path");
            element2.appendChild(cDATASection);
            element.appendChild(element2);
        }
        return element;
    }

    public void loadXMLElement(Element element) throws SAXException {
        Element element2 = (Element)XMLTools.getChildElementsByTagName(element, "File").iterator().next();
        this.fileObj = SharedFileObject.getInstance(element2);
        assert (this.fileObj != null);
        if (XMLTools.getChildElementsByTagName(element, "path").size() > 0) {
            this.fileObj.setFile(new File(XMLTools.getChildElementsCDATAValue(element, "path")));
        }
    }

    public FileAttachment(Element element) throws SAXException {
        this.loadXMLElement(element);
    }

    public FileAttachment(SharedFileObject sharedFileObject) {
        this.fileObj = sharedFileObject;
    }

    public SharedFileObject getFileObj() {
        return this.fileObj;
    }

    public int compareTo(Object object) {
        String string = this.fileObj.getFilename();
        String string2 = ((FileAttachment)object).getFileObj().getFilename();
        return string.compareTo(string2);
    }
}

