/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.Mixed;
import frost.SafeXMLizable;
import frost.XMLTools;
import frost.gui.objects.Board;
import frost.messages.Attachment;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class BoardAttachment
extends Attachment
implements SafeXMLizable {
    private Board boardObj;

    public int getType() {
        return 1;
    }

    public Element getXMLElement(Document document) {
        Element element = this.getSafeXMLElement(document);
        Element element2 = document.createElement("privKey");
        CDATASection cDATASection = document.createCDATASection(Mixed.makeSafeXML(this.boardObj.getPrivateKey()));
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        Element element3 = document.createElement("description");
        cDATASection = document.createCDATASection(Mixed.makeSafeXML(this.boardObj.getDescription()));
        element3.appendChild(cDATASection);
        element.appendChild(element3);
        return element;
    }

    public Element getSafeXMLElement(Document document) {
        Element element = document.createElement("Attachment");
        element.setAttribute("type", "board");
        Element element2 = document.createElement("Name");
        CDATASection cDATASection = document.createCDATASection(Mixed.makeSafeXML(this.boardObj.getName()));
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        Element element3 = document.createElement("pubKey");
        cDATASection = document.createCDATASection(Mixed.makeSafeXML(this.boardObj.getPublicKey()));
        element3.appendChild(cDATASection);
        element.appendChild(element3);
        return element;
    }

    public void loadXMLElement(Element element) throws SAXException {
        String string = XMLTools.getChildElementsCDATAValue(element, "Name");
        String string2 = XMLTools.getChildElementsCDATAValue(element, "privKey");
        String string3 = XMLTools.getChildElementsCDATAValue(element, "pubKey");
        String string4 = XMLTools.getChildElementsCDATAValue(element, "description");
        this.boardObj = new Board(string, string3, string2, string4);
    }

    protected BoardAttachment(Element element) throws SAXException {
        this.loadXMLElement(element);
    }

    public BoardAttachment(Board board) {
        this.boardObj = board;
    }

    public Board getBoardObj() {
        return this.boardObj;
    }

    public String toString() {
        if (this.getBoardObj() != null) {
            return this.getBoardObj().getName();
        }
        return "*ERR*";
    }

    public int compareTo(Object object) {
        String string = this.toString();
        String string2 = ((BoardAttachment)object).toString();
        return string.compareToIgnoreCase(string2);
    }
}

