/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.XMLTools;
import frost.XMLizable;
import frost.messages.Attachment;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AttachmentList
extends LinkedList
implements XMLizable {
    private static Logger logger = Logger.getLogger(AttachmentList.class.getName());

    public AttachmentList getAllOfType(int n) {
        assert (n == 0 || n == 1 || n == 2) : "list of unknown type of attachments requested";
        Iterator iterator = this.iterator();
        AttachmentList attachmentList = new AttachmentList();
        while (iterator.hasNext()) {
            Attachment attachment = (Attachment)iterator.next();
            if (attachment.getType() != n) continue;
            attachmentList.add(attachment);
        }
        return attachmentList;
    }

    public synchronized Element getXMLElement(Document document) {
        if (this.size() == 0) {
            return null;
        }
        Element element = document.createElement("AttachmentList");
        for (Attachment attachment : this) {
            element.appendChild(attachment.getXMLElement(document));
        }
        return element;
    }

    public void loadXMLElement(Element element) throws SAXException {
        if (element == null) {
            return;
        }
        for (Element element2 : XMLTools.getChildElementsByTagName(element, "Attachment")) {
            Attachment attachment = Attachment.getInstance(element2);
            this.add(attachment);
        }
        if (this.size() == 0) {
            logger.info("empty attachment list upon creation");
        }
    }
}

