/*
 * Decompiled with CFR 0.152.
 */
package frost.messages;

import frost.XMLizable;
import frost.messages.BoardAttachment;
import frost.messages.FileAttachment;
import frost.messages.PersonAttachment;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public abstract class Attachment
implements XMLizable,
Comparable {
    public static final int FILE = 0;
    public static final int BOARD = 1;
    public static final int PERSON = 2;
    private static Logger logger = Logger.getLogger(Attachment.class.getName());

    public abstract int getType();

    public static Attachment getInstance(Element element) {
        assert (element.getAttribute("type").length() > 0) : "attachment type not specified!";
        try {
            if (element.getAttribute("type").equals("file")) {
                return new FileAttachment(element);
            }
            if (element.getAttribute("type").equals("board")) {
                return new BoardAttachment(element);
            }
            return new PersonAttachment(element);
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, "Exception thrown in getInstance(Element e)", sAXException);
            return null;
        }
    }
}

