/*
 * Decompiled with CFR 0.152.
 */
package frost.identities;

import frost.Core;
import frost.Mixed;
import frost.SafeXMLizable;
import frost.XMLTools;
import frost.messages.BoardAttachment;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class Identity
implements SafeXMLizable {
    private String name;
    private String uniqueName;
    protected String key;
    private long lastSeenTimestamp = -1L;
    int state = -1;
    private static Logger logger = Logger.getLogger(Identity.class.getName());

    public Identity(Element element) {
        try {
            this.loadXMLElement(element);
        }
        catch (SAXException sAXException) {
            logger.log(Level.SEVERE, "Exception thrown in constructor", sAXException);
        }
    }

    public Element getXMLElement(Document document) {
        Element element = this.getSafeXMLElement(document);
        if (this.getLastSeenTimestamp() > 0L) {
            Element element2 = document.createElement("lastSeen");
            Text text = document.createTextNode("" + this.getLastSeenTimestamp());
            element2.appendChild(text);
            element.appendChild(element2);
        }
        return element;
    }

    public Element getSafeXMLElement(Document document) {
        Element element = document.createElement("Identity");
        Element element2 = document.createElement("name");
        CDATASection cDATASection = document.createCDATASection(this.getUniqueName());
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        element2 = document.createElement("key");
        cDATASection = document.createCDATASection(this.getKey());
        element2.appendChild(cDATASection);
        element.appendChild(element2);
        return element;
    }

    public void loadXMLElement(Element element) throws SAXException {
        this.uniqueName = XMLTools.getChildElementsCDATAValue(element, "name");
        this.name = this.uniqueName.substring(0, this.uniqueName.indexOf("@"));
        this.key = XMLTools.getChildElementsCDATAValue(element, "key");
        String string = XMLTools.getChildElementsTextValue(element, "lastSeen");
        this.lastSeenTimestamp = string != null && (string = string.trim()).length() > 0 ? Long.parseLong(string) : System.currentTimeMillis();
    }

    public Identity(String string, String string2) {
        this.key = string2;
        this.name = string;
        if (string.indexOf("@") != -1) {
            this.uniqueName = string;
        } else {
            this.setName(string);
        }
    }

    private void setName(String string) {
        this.name = string;
        this.uniqueName = string + "@" + Core.getCrypto().digest(this.getKey());
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getStrippedName() {
        return new String(this.name.substring(0, this.name.indexOf("@")));
    }

    public String getUniqueName() {
        return Mixed.makeFilename(this.uniqueName);
    }

    public static boolean isForbiddenBoardAttachment(BoardAttachment boardAttachment) {
        return boardAttachment != null && boardAttachment.getBoardObj().getPublicKey() != null && boardAttachment.getBoardObj().getPublicKey().startsWith("SSK@");
    }

    public long getLastSeenTimestamp() {
        return this.lastSeenTimestamp;
    }

    public void updateLastSeenTimestamp() {
        this.lastSeenTimestamp = System.currentTimeMillis();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
    }

    public String toString() {
        return this.getUniqueName();
    }
}

