/*
 * Decompiled with CFR 0.152.
 */
package frost.identities;

import frost.FileAccess;
import frost.XMLTools;
import frost.identities.BuddyList;
import frost.identities.FrostIdentities;
import frost.identities.IdentitiesDAO;
import frost.identities.LocalIdentity;
import frost.storage.StorageException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class IdentitiesXmlDAO
implements IdentitiesDAO {
    private static Logger logger = Logger.getLogger(IdentitiesXmlDAO.class.getName());
    private static final String XML_FILENAME = "identities.xml";
    private static final String TMP_FILENAME = "identities.xml.tmp";
    private static final String BAK_FILENAME = "identities.xml.bak";

    public boolean exists() {
        File file = new File(XML_FILENAME);
        if (file.length() == 0L) {
            file.delete();
        }
        return file.exists();
    }

    private void loadNewFormat(FrostIdentities frostIdentities) throws SAXException, IllegalArgumentException {
        logger.info("Trying to create/load ids");
        Document document = XMLTools.parseXmlFile(XML_FILENAME, false);
        Element element = document.getDocumentElement();
        Element element2 = (Element)XMLTools.getChildElementsByTagName(element, "MyIdentity").get(0);
        LocalIdentity localIdentity = null;
        if (element2 != null) {
            localIdentity = new LocalIdentity(element2);
            frostIdentities.setMyId(localIdentity);
        } else {
            frostIdentities.setMyId(null);
        }
        ArrayList arrayList = XMLTools.getChildElementsByTagName(element, "BuddyList");
        Iterator iterator = arrayList.iterator();
        BuddyList buddyList = frostIdentities.getFriends();
        BuddyList buddyList2 = frostIdentities.getEnemies();
        BuddyList buddyList3 = frostIdentities.getNeutrals();
        BuddyList buddyList4 = frostIdentities.getObserved();
        while (iterator.hasNext()) {
            Element element3 = (Element)iterator.next();
            if (element3.getAttribute("type").equals("friends")) {
                buddyList.loadXMLElement(element3);
                continue;
            }
            if (element3.getAttribute("type").equals("enemies")) {
                buddyList2.loadXMLElement(element3);
                continue;
            }
            if (element3.getAttribute("type").equals("neutral")) {
                buddyList3.loadXMLElement(element3);
                continue;
            }
            if (!element3.getAttribute("type").equals("observed")) continue;
            buddyList4.loadXMLElement(element3);
        }
        logger.info("Loaded " + buddyList.size() + " friends and " + buddyList2.size() + " enemies, " + buddyList3.size() + " neutrals and " + buddyList4.size() + " observed.");
    }

    public void load(FrostIdentities frostIdentities) throws StorageException {
        File file = new File(XML_FILENAME);
        if (file.exists()) {
            try {
                this.loadNewFormat(frostIdentities);
            }
            catch (Exception exception) {
                throw new StorageException("Exception while loading the new identities format.", exception);
            }
        }
    }

    public void create() throws StorageException {
        File file = new File(XML_FILENAME);
        try {
            boolean bl = file.createNewFile();
            if (!bl) {
                throw new StorageException("There was a problem while creating the storage.");
            }
        }
        catch (IOException iOException) {
            throw new StorageException("There was a problem while creating the storage.", iOException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(FrostIdentities frostIdentities) throws StorageException {
        File file;
        logger.info("Saving identities.xml");
        File file2 = new File(XML_FILENAME);
        if (file2.exists()) {
            file = new File(BAK_FILENAME);
            file.delete();
            if (!FileAccess.copyFile(XML_FILENAME, BAK_FILENAME)) {
                logger.log(Level.SEVERE, "Error while copying identities.xml to identities.xml.bak");
            }
        }
        if ((file = new File(TMP_FILENAME)).exists()) {
            file.delete();
        }
        Document document = XMLTools.createDomDocument();
        Element element = document.createElement("FrostIdentities");
        element.appendChild(frostIdentities.getMyId().getXMLElement(document));
        Element element2 = frostIdentities.getFriends().getXMLElement(document);
        element2.setAttribute("type", "friends");
        element.appendChild(element2);
        Element element3 = frostIdentities.getEnemies().getXMLElement(document);
        element3.setAttribute("type", "enemies");
        element.appendChild(element3);
        Element element4 = frostIdentities.getNeutrals().getXMLElement(document);
        element4.setAttribute("type", "neutral");
        element.appendChild(element4);
        Element element5 = frostIdentities.getObserved().getXMLElement(document);
        element5.setAttribute("type", "observed");
        element.appendChild(element5);
        document.appendChild(element);
        if (!XMLTools.writeXmlFile(document, TMP_FILENAME)) throw new StorageException("Could not save identities.xml");
        if (!file.exists()) throw new StorageException("Could not save identities.xml");
        file2.delete();
        if (file.renameTo(file2) || FileAccess.copyFile(BAK_FILENAME, XML_FILENAME)) return;
        throw new StorageException("Error while restoring identities.xml");
    }
}

